/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph3D;

import java.util.ArrayList;
import org.gwoptics.ArgumentException;
import org.gwoptics.ValueType;
import org.gwoptics.graphics.GWColour;
import org.gwoptics.graphics.Renderable;
import org.gwoptics.graphics.colourmap.IColourmap;
import org.gwoptics.graphics.graph3D.Axis3D;
import org.gwoptics.graphics.graph3D.IGraph3DCallback;
import org.gwoptics.graphics.graph3D.SurfaceTrace3D;
import processing.core.PApplet;
import processing.core.PVector;

public final class SurfaceGraph3D
extends Renderable {
    private Axis3D _ax;
    private Axis3D _az;
    private Axis3D _ay;
    private ArrayList<SurfaceTrace3D> _traces;
    private float _xLength;
    private float _zLength;
    private float _yLength;
    private int _autoRangeSurfaceIX;
    private boolean _setAxisCrossAtZero;

    public float getZAxisMax() {
        return this._az.getMaxValue();
    }

    public void setXAxisMin(float f) {
        this._ax.setMinValue(f);
        this._alterSurfaceSpacing();
        this._alignAxesToZeroPoint();
    }

    public void setYAxisMin(float f) {
        this._ay.setMinValue(f);
        this._alterSurfaceSpacing();
        this._alignAxesToZeroPoint();
    }

    public void setZAxisMin(float f) {
        this._az.setMinValue(f);
        this._alignAxesToZeroPoint();
    }

    public void setXAxisMax(float f) {
        this._ax.setMaxValue(f);
        this._alignAxesToZeroPoint();
    }

    public void setYAxisMax(float f) {
        this._ay.setMaxValue(f);
        this._alterSurfaceSpacing();
        this._alignAxesToZeroPoint();
    }

    public void setZAxisMax(float f) {
        this._az.setMaxValue(f);
        this._alterSurfaceSpacing();
        this._alignAxesToZeroPoint();
    }

    public void setXAxisLabel(String string) {
        this._ax.setAxisLabel(string);
    }

    public void setYAxisLabel(String string) {
        this._ay.setAxisLabel(string);
    }

    public void setZAxisLabel(String string) {
        this._az.setAxisLabel(string);
    }

    public void setXAxisLabelAccuracy(int n) {
        this._ax.setTickLabelAccuracy(n);
    }

    public void setYAxisLabelAccuracy(int n) {
        this._ay.setTickLabelAccuracy(n);
    }

    public void setZAxisLabelAccuracy(int n) {
        this._az.setTickLabelAccuracy(n);
    }

    public void setXAxisLabelType(ValueType valueType) {
        this._ax.setTickLabelType(valueType);
    }

    public void setYAxisLabelType(ValueType valueType) {
        this._ay.setTickLabelType(valueType);
    }

    public void setZAxisLabelType(ValueType valueType) {
        this._az.setTickLabelType(valueType);
    }

    public void setXAxisMajorTicks(int n) {
        this._ax.setMajorTicks(n);
    }

    public void setXAxisMinorTicks(int n) {
        this._ax.setMinorTicks(n);
    }

    public void setYAxisMajorTicks(int n) {
        this._ay.setMajorTicks(n);
    }

    public void setYAxisMinorTicks(int n) {
        this._ay.setMinorTicks(n);
    }

    public void setZAxisMajorTicks(int n) {
        this._az.setMajorTicks(n);
    }

    public void setZAxisMinorTicks(int n) {
        this._az.setMinorTicks(n);
    }

    public void setBillboarding(boolean bl) {
        this._ax.setTickLabelBillboarding(bl);
        this._ay.setTickLabelBillboarding(bl);
        this._az.setTickLabelBillboarding(bl);
    }

    public void setDrawLines(boolean bl) {
        this._ax.setDrawLine(bl);
        this._ay.setDrawLine(bl);
        this._az.setDrawLine(bl);
    }

    public void setDrawTickLabels(boolean bl) {
        this._ax.setDrawTickLabels(bl);
        this._ay.setDrawTickLabels(bl);
        this._az.setDrawTickLabels(bl);
    }

    public void setDrawTicks(boolean bl) {
        this._ax.setDrawTicks(bl);
        this._ay.setDrawTicks(bl);
        this._az.setDrawTicks(bl);
    }

    public void setDrawAxisLabel(boolean bl) {
        this._ax.setDrawAxisLabel(bl);
        this._ay.setDrawAxisLabel(bl);
        this._az.setDrawAxisLabel(bl);
    }

    public void setAxisColour(int n, int n2, int n3) {
        this.setAxisColour(new GWColour(n, n2, n3));
    }

    public void setAxisColour(GWColour gWColour) {
        if (gWColour == null) {
            throw new NullPointerException("Colour argument cannot be null");
        }
        this._ax.setAxisColour(gWColour);
        this._ay.setAxisColour(gWColour);
        this._az.setAxisColour(gWColour);
    }

    public void setFontColour(int n, int n2, int n3) {
        this.setFontColour(new GWColour(n, n2, n3));
    }

    public void setFontColour(GWColour gWColour) {
        if (gWColour == null) {
            throw new NullPointerException("Colour argument cannot be null");
        }
        this._ax.setFontColour(gWColour);
        this._ay.setFontColour(gWColour);
        this._az.setFontColour(gWColour);
    }

    public void setAutoRanging(int n) {
        if (n > this._traces.size() - 1) {
            throw new ArgumentException("This surface trace index does not exist in the traces available");
        }
        SurfaceTrace3D surfaceTrace3D = null;
        if (this._autoRangeSurfaceIX > -1 && (surfaceTrace3D = this._traces.get(this._autoRangeSurfaceIX)) != null) {
            surfaceTrace3D.setAutoRangeZAxis(false);
        }
        if (n < -1) {
            n = -1;
        }
        this._autoRangeSurfaceIX = n;
        if (n > -1 && (surfaceTrace3D = this._traces.get(n)) != null) {
            surfaceTrace3D.setAutoRangeZAxis(true);
        }
    }

    public SurfaceGraph3D(PApplet pApplet, float f, float f2, float f3) {
        this(pApplet, f, f2, f3, false);
    }

    public SurfaceGraph3D(PApplet pApplet, float f, float f2, float f3, boolean bl) {
        super(pApplet);
        this._az = new Axis3D(this._parent);
        this._ax = new Axis3D(this._parent);
        this._ay = new Axis3D(this._parent);
        if (f < 1.0f) {
            this._xLength = 1.0f;
            this._ax.setDraw(false);
        } else {
            this._xLength = f;
        }
        if (f3 < 1.0f) {
            this._zLength = 1.0f;
            this._az.setDraw(false);
        } else {
            this._zLength = f3;
        }
        if (f2 < 1.0f) {
            this._yLength = 1.0f;
            this._ay.setDraw(false);
        } else {
            this._yLength = f2;
        }
        this._traces = new ArrayList();
        this._autoRangeSurfaceIX = -1;
        this._az.setAxesDirection(new PVector(0.0f, 1.0f, 0.0f));
        this._az.setAxisLabel("Z-Axis");
        this._az.position = new PVector(0.0f, 0.0f, 0.0f);
        this._az.setLength(this._zLength);
        this._az.setLabelDirection(new PVector(-1.0f, 0.0f, -1.0f));
        this._az.setTickLabelXRotation((float)Math.PI);
        this._az.setTickLabelYRotation(-2.3561945f);
        this._az.setLabelZRotation(1.5707964f);
        this._az.setLabelXRotation(2.6179938f);
        this._az.setTickLabelBillboarding(false);
        this._ax.setAxesDirection(new PVector(1.0f, 0.0f, 0.0f));
        this._ax.setAxisLabel("X-Axis");
        this._ax.setLabelXRotation(-1.5707964f);
        this._ax.setLabelOffset(10.0f);
        this._ax.setLength(this._xLength);
        this._ax.setTickLabelYRotation(1.5707964f);
        this._ax.setTickLabelZRotation(1.5707964f);
        this._ax.setLabelDirection(new PVector(0.0f, 0.0f, -1.0f));
        this._ax.position = new PVector(0.0f, 0.0f, 0.0f);
        this._ax.setTickLabelBillboarding(false);
        this._ay.setAxesDirection(new PVector(0.0f, 0.0f, 1.0f));
        this._ay.setAxisLabel("Y-Axis");
        this._ay.setLength(this._yLength);
        this._ay.setLabelOffset(10.0f);
        this._ay.setLabelXRotation((float)Math.PI);
        this._ay.setLabelYRotation(1.5707964f);
        this._ay.setLabelZRotation(1.5707964f);
        this._ay.setTickLabelYRotation(1.5707964f);
        this._ay.setTickLabelZRotation(1.5707964f);
        this._ay.setTickLabelXRotation(-1.5707964f);
        this._ay.setLabelDirection(new PVector(-1.0f, 0.0f, 0.0f));
        this._ay.position = new PVector(0.0f, 0.0f, 0.0f);
        this._ay.setTickLabelBillboarding(false);
        this._setAxisCrossAtZero = bl;
    }

    private void _alignAxesToZeroPoint() {
        if (this._setAxisCrossAtZero && this._az.getMinValue() <= 0.0f && this._az.getMaxValue() >= 0.0f) {
            float f = Math.abs(this._az.getLength() * Math.abs(this._az.getMinValue() / (this._az.getMaxValue() - this._az.getMinValue())));
            this._ax.position = new PVector(0.0f, f, 0.0f);
            this._ay.position = new PVector(0.0f, f, 0.0f);
        } else {
            this._ax.position = new PVector(0.0f, 0.0f, 0.0f);
            this._ay.position = new PVector(0.0f, 0.0f, 0.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _alterSurfaceSpacing() {
        ArrayList<SurfaceTrace3D> arrayList = this._traces;
        synchronized (arrayList) {
            for (SurfaceTrace3D surfaceTrace3D : this._traces) {
                surfaceTrace3D.calculateSpacing();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTraceCount() {
        ArrayList<SurfaceTrace3D> arrayList = this._traces;
        synchronized (arrayList) {
            return this._traces.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSurfaceTrace(IGraph3DCallback iGraph3DCallback, int n, int n2, IColourmap iColourmap) {
        ArrayList<SurfaceTrace3D> arrayList = this._traces;
        synchronized (arrayList) {
            this._traces.add(new SurfaceTrace3D(this._parent, this._ax, this._ay, this._az, n, n2, iGraph3DCallback, String.valueOf(this._traces.size() + 1), iColourmap));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSurfaceTrace(int n) {
        ArrayList<SurfaceTrace3D> arrayList = this._traces;
        synchronized (arrayList) {
            if (this._traces.size() <= n) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this._traces.remove(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void plotSurfaceTrace(int n) {
        ArrayList<SurfaceTrace3D> arrayList = this._traces;
        synchronized (arrayList) {
            if (this._traces.size() <= n) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this._traces.get(n).generateSurface();
        }
    }

    public void setTraceStroke(int n, GWColour gWColour) {
        if (this._traces.size() <= n) {
            throw new ArrayIndexOutOfBoundsException();
        }
        SurfaceTrace3D surfaceTrace3D = this._traces.get(n);
        if (gWColour == null) {
            surfaceTrace3D.setIsSurfacedStroked(false);
        } else {
            surfaceTrace3D.setIsSurfacedStroked(true);
            surfaceTrace3D.setSurfaceStroke(gWColour);
        }
    }

    public void setTraceFill(int n, GWColour gWColour) {
        if (this._traces.size() <= n) {
            throw new ArrayIndexOutOfBoundsException();
        }
        SurfaceTrace3D surfaceTrace3D = this._traces.get(n);
        if (gWColour == null) {
            surfaceTrace3D.setIsSurfaceFilled(false);
        } else {
            surfaceTrace3D.setIsSurfaceFilled(true);
            surfaceTrace3D.setSurfaceFill(gWColour);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void draw() {
        ArrayList<SurfaceTrace3D> arrayList = this._traces;
        synchronized (arrayList) {
            this._parent.pushMatrix();
            this._parent.translate(this.position.x, this.position.y, this.position.z);
            for (SurfaceTrace3D surfaceTrace3D : this._traces) {
                surfaceTrace3D.draw();
            }
            this._alignAxesToZeroPoint();
            this._ax.draw();
            this._ay.draw();
            this._az.draw();
            this._parent.popMatrix();
        }
    }
}

