/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph3D;

import org.gwoptics.graphics.GWColour;
import org.gwoptics.graphics.Renderable;
import processing.core.PApplet;

public class SquareGridMesh
extends Renderable {
    private int _X_size = 11;
    private int _Y_size = 11;
    private float _dx = 10.0f;
    private float _dy = 10.0f;
    protected float[][][] _vertexs;
    protected int[][][] _colour;
    public boolean isColoured;
    public GWColour strokeColour;
    public boolean isFilled;
    public GWColour fillColour;
    public boolean isStroked;

    public float getWidth() {
        return this._dx * (float)(this._X_size - 1);
    }

    public float getLength() {
        return this._dy * (float)(this._Y_size - 1);
    }

    public SquareGridMesh(int n, int n2, float f, float f2, PApplet pApplet) {
        super(pApplet);
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Grid size dimensions should be greater than 0.");
        }
        this._X_size = n + 1;
        this._Y_size = n2 + 1;
        this._dx = f;
        this._dy = f2;
        this.isColoured = false;
        this.isFilled = false;
        this.isStroked = true;
        this.strokeColour = new GWColour(1, 1, 1);
        this.fillColour = new GWColour(0.5f, 0.5f, 0.5f);
        this._vertexs = new float[this._X_size][this._Y_size][3];
        this._colour = new int[this._X_size][this._Y_size][3];
        for (int i = 0; i < this._vertexs.length; ++i) {
            for (int j = 0; j < this._vertexs[0].length; ++j) {
                this._vertexs[i][j][0] = (float)i * this._dx;
                this._vertexs[i][j][2] = (float)j * this._dy;
            }
        }
    }

    public void setZValue(int n, int n2, float f) {
        if (n < 0 || n2 < 0 || n > this._X_size - 1 || n2 > this._Y_size - 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this._vertexs[n][n2][1] = f;
    }

    public void setVertexColour(int n, int n2, GWColour gWColour) {
        if (n < 0 || n2 < 0 || n > this._X_size - 1 || n2 > this._Y_size - 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this._colour[n][n2][0] = (int)(gWColour.R * 255.0f);
        this._colour[n][n2][1] = (int)(gWColour.G * 255.0f);
        this._colour[n][n2][2] = (int)(gWColour.B * 255.0f);
    }

    public float getZValue(int n, int n2) {
        return this._vertexs[n][n2][1];
    }

    @Override
    public void draw() {
        this._parent.pushMatrix();
        if (this.isColoured) {
            this._ColouredDraw();
        } else {
            this._noColourDraw();
        }
        this._parent.popMatrix();
    }

    private void _noColourDraw() {
        if (this.isFilled) {
            this._parent.fill(this.fillColour.toInt());
        } else {
            this._parent.noFill();
        }
        if (this.isStroked) {
            this._parent.stroke(this.strokeColour.toInt());
        } else {
            this._parent.noStroke();
        }
        for (int i = 0; i < this._vertexs.length - 1; ++i) {
            this._parent.beginShape(10);
            for (int j = 0; j < this._vertexs[0].length; ++j) {
                this._parent.vertex(this._vertexs[i][j][0], this._vertexs[i][j][1], this._vertexs[i][j][2]);
                this._parent.vertex(this._vertexs[i + 1][j][0], this._vertexs[i + 1][j][1], this._vertexs[i + 1][j][2]);
            }
            this._parent.endShape();
        }
    }

    private void _ColouredDraw() {
        this._parent.noStroke();
        for (int i = 0; i < this._vertexs.length - 1; ++i) {
            this._parent.beginShape(10);
            for (int j = 0; j < this._vertexs[0].length; ++j) {
                int n = i + 1;
                this._parent.fill((float)this._colour[i][j][0], (float)this._colour[i][j][1], (float)this._colour[i][j][2]);
                this._parent.vertex(this._vertexs[i][j][0], this._vertexs[i][j][1], this._vertexs[i][j][2]);
                this._parent.fill((float)this._colour[n][j][0], (float)this._colour[n][j][1], (float)this._colour[n][j][2]);
                this._parent.vertex(this._vertexs[i + 1][j][0], this._vertexs[i + 1][j][1], this._vertexs[i + 1][j][2]);
            }
            this._parent.endShape();
        }
    }

    public int sizeX() {
        return this._X_size - 1;
    }

    public int sizeY() {
        return this._Y_size - 1;
    }
}

