/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph3D;

import org.gwoptics.ValueType;
import org.gwoptics.graphics.GWColour;
import org.gwoptics.graphics.Renderable;
import org.gwoptics.graphics.camera.Camera3D;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PFont;
import processing.core.PVector;

public class Axis3D
extends Renderable
implements PConstants {
    private PVector _unitVec;
    private float _length = 100.0f;
    private float _minShow = 0.0f;
    private float _maxShow = 1.0f;
    private int _axisLineWidth = 2;
    private int _axisTickLineWidth = 1;
    private static PFont _font;
    private String _label;
    private PVector _labelDirection;
    private int _majorTicks = 5;
    private int _minorTicks = 2;
    private int _majorTickSize = 10;
    private int _minorTickSize = 5;
    private int _axisTickLblSize = 8;
    private int _axisLblSize = 20;
    private PVector _axisTickLblRotation = new PVector(0.0f, 0.0f, 0.0f);
    private PVector _axisLblRotation = new PVector(0.0f, 0.0f, 0.0f);
    private float _axisLblOffset = 20.0f;
    private GWColour _axisColour = new GWColour(0, 0, 0);
    private GWColour _fontColour = new GWColour(0, 0, 0);
    private boolean _drawLine = true;
    private boolean _drawTicks = true;
    private boolean _drawTickLabels = true;
    private boolean _drawName = true;
    private boolean _textBillboard;
    private ValueType _tickLblType = ValueType.EXPONENT;
    private int _accuracy = 1;

    public void setAxisColour(int n, int n2, int n3) {
        this.setAxisColour(new GWColour(n, n2, n3));
    }

    public void setAxisColour(GWColour gWColour) {
        if (gWColour == null) {
            throw new NullPointerException("Colour argument cannot be null");
        }
        this._axisColour = gWColour;
    }

    public void setFontColour(int n, int n2, int n3) {
        this.setFontColour(new GWColour(n, n2, n3));
    }

    public void setFontColour(GWColour gWColour) {
        if (gWColour == null) {
            throw new NullPointerException("Colour argument cannot be null");
        }
        this._fontColour = gWColour;
    }

    public void setTickLabelBillboarding(boolean bl) {
        if (bl) {
            if (Camera3D.getLookat() == null) {
                throw new RuntimeException("To use text billboards you must use the Camera3object in your scene.");
            }
            this._textBillboard = bl;
        } else {
            this._textBillboard = false;
        }
    }

    public void setDraw(boolean bl) {
        this._drawLine = bl;
        this._drawTicks = bl;
        this._drawTickLabels = bl;
        this._drawName = bl;
    }

    public void setDrawLine(boolean bl) {
        this._drawLine = bl;
    }

    public void setDrawTicks(boolean bl) {
        this._drawTicks = bl;
    }

    public void setDrawTickLabels(boolean bl) {
        this._drawTickLabels = bl;
    }

    public void setDrawAxisLabel(boolean bl) {
        this._drawName = bl;
    }

    public void setAxisLabel(String string) {
        this._label = string;
    }

    public void setLabelOffset(float f) {
        this._axisLblOffset = f;
    }

    public void setTickLabelXRotation(float f) {
        this._axisTickLblRotation.x = f;
    }

    public void setTickLabelYRotation(float f) {
        this._axisTickLblRotation.y = f;
    }

    public void setTickLabelZRotation(float f) {
        this._axisTickLblRotation.z = f;
    }

    public void setLabelXRotation(float f) {
        this._axisLblRotation.x = f;
    }

    public void setLabelYRotation(float f) {
        this._axisLblRotation.y = f;
    }

    public void setLabelZRotation(float f) {
        this._axisLblRotation.z = f;
    }

    public void setLabelDirection(PVector pVector) {
        pVector.normalize();
        this._labelDirection = pVector;
    }

    public void setAxesDirection(PVector pVector) {
        pVector.normalize();
        this._unitVec = pVector;
    }

    public void setMajorTicks(int n) {
        this._majorTicks = n;
    }

    public void setMinorTicks(int n) {
        this._minorTicks = n;
    }

    public void setTickLabelType(ValueType valueType) {
        this._tickLblType = valueType;
    }

    public void setTickLabelAccuracy(int n) {
        this._accuracy = n;
    }

    public void setMajorTickLength(int n) {
        this._majorTickSize = n;
    }

    public void setMinorTickLength(int n) {
        this._minorTickSize = n;
    }

    public void setMaxValue(float f) {
        this._maxShow = f;
    }

    public void setMinValue(float f) {
        this._minShow = f;
    }

    public void setLength(float f) {
        this._length = f;
    }

    public float getMaxValue() {
        return this._maxShow;
    }

    public float getMinValue() {
        return this._minShow;
    }

    public float getLength() {
        return this._length;
    }

    public Axis3D(PApplet pApplet) {
        super(pApplet);
        this._unitVec = new PVector(1.0f, 0.0f, 0.0f);
        if (_font == null) {
            _font = pApplet.createFont("Verdana", 72.0f);
        }
    }

    @Override
    public void draw() {
        PVector pVector;
        this._parent.pushStyle();
        this._parent.pushMatrix();
        this._parent.translate(this.position.x, this.position.y, this.position.z);
        this._parent.textAlign(3);
        PVector pVector2 = PVector.mult((PVector)this._unitVec, (float)this._length);
        if (this._drawLine) {
            this._parent.stroke(this._axisColour.toInt());
            this._parent.fill(this._fontColour.toInt());
            this._parent.strokeWeight((float)this._axisLineWidth);
            this._parent.line(0.0f, 0.0f, 0.0f, pVector2.x, pVector2.y, pVector2.z);
        }
        float f = 0.0f;
        PVector pVector3 = null;
        PVector pVector4 = null;
        PVector pVector5 = null;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this._drawTicks || this._drawTickLabels) {
            pVector = PVector.div((PVector)pVector2, (float)this._majorTicks);
            PVector pVector6 = PVector.div((PVector)pVector, (float)(this._minorTicks + 1));
            PVector pVector7 = new PVector(0.0f, 0.0f, 0.0f);
            PVector pVector8 = new PVector(0.0f, 0.0f, 0.0f);
            PVector pVector9 = new PVector(0.0f, 0.0f, 0.0f);
            PVector pVector10 = new PVector(0.0f, 0.0f, 0.0f);
            String string = null;
            float f4 = (this._maxShow - this._minShow) / (float)this._majorTicks;
            this._parent.strokeWeight((float)this._axisTickLineWidth);
            this._parent.textFont(_font, (float)(this._axisTickLblSize * 2));
            if (this._textBillboard) {
                pVector4 = Camera3D.getEyeVector().get();
                pVector4.normalize();
                pVector3 = Camera3D.getPosition().get();
                pVector3.sub(Camera3D.getLookat());
                pVector3.sub(this.position);
                pVector5 = new PVector(pVector3.x, 0.0f, pVector3.z);
                pVector5.normalize();
                f2 = (float)Math.atan2(pVector3.x, pVector3.z);
                f3 = (float)Math.acos(pVector5.dot(pVector4));
            }
            for (int i = 0; i <= this._majorTicks; ++i) {
                switch (this._tickLblType) {
                    case DECIMAL: {
                        string = String.format("% ." + this._accuracy + "f", Float.valueOf(this._minShow + (float)i * f4));
                        break;
                    }
                    case EXPONENT: {
                        string = String.format("% ." + this._accuracy + "E", Float.valueOf(this._minShow + (float)i * f4));
                        break;
                    }
                    case INTEGER: {
                        string = String.format("% d", Math.round(this._minShow + (float)i * f4));
                    }
                }
                if ((float)string.length() > f) {
                    f = this._parent.textWidth(string);
                }
                PVector pVector11 = PVector.add((PVector)pVector7, (PVector)PVector.mult((PVector)this._labelDirection, (float)(1.0f + this._parent.textWidth(string) / 2.0f + (float)Math.abs(this._majorTickSize))));
                pVector11.add(PVector.mult((PVector)this._unitVec, (float)((float)((double)this._axisTickLblSize * 1.2))));
                pVector8 = PVector.add((PVector)pVector7, (PVector)PVector.mult((PVector)this._labelDirection, (float)this._majorTickSize));
                if (this._drawTickLabels) {
                    this._parent.pushMatrix();
                    this._parent.translate(pVector11.x, pVector11.y, pVector11.z);
                    if (this._textBillboard) {
                        this._parent.rotateZ((float)Math.PI);
                        this._parent.rotateY(-f2);
                        if (Math.signum(pVector3.y) == 1.0f) {
                            this._parent.rotateX((float)Math.PI - f3);
                        } else {
                            this._parent.rotateX((float)Math.PI + f3);
                        }
                    } else {
                        this._parent.rotateZ(this._axisTickLblRotation.z);
                        this._parent.rotateX(this._axisTickLblRotation.x);
                        this._parent.rotateY(this._axisTickLblRotation.y);
                    }
                    this._parent.text(string, 0.0f, 0.25f * (float)_font.getSize(), 0.0f);
                    this._parent.popMatrix();
                }
                if (this._drawTicks) {
                    this._parent.line(pVector7.x, pVector7.y, pVector7.z, pVector8.x, pVector8.y, pVector8.z);
                    if (i != 0) {
                        pVector9 = pVector7.get();
                        for (int j = 0; j < this._minorTicks; ++j) {
                            pVector9 = PVector.sub((PVector)pVector9, (PVector)pVector6);
                            pVector10 = PVector.add((PVector)pVector9, (PVector)PVector.mult((PVector)this._labelDirection, (float)this._minorTickSize));
                            this._parent.line(pVector9.x, pVector9.y, pVector9.z, pVector10.x, pVector10.y, pVector10.z);
                        }
                    }
                }
                pVector7.add(pVector);
            }
        }
        this._parent.popMatrix();
        if (this._drawName) {
            this._parent.textFont(_font, (float)this._axisLblSize);
            pVector = PVector.add((PVector)this.position, (PVector)PVector.div((PVector)pVector2, (float)2.0f));
            pVector.add(PVector.mult((PVector)this._labelDirection, (float)(f + (float)this._axisLblSize + this._axisLblOffset)));
            this._parent.pushMatrix();
            this._parent.translate(pVector.x, pVector.y, pVector.z);
            this._parent.rotateZ(this._axisLblRotation.z);
            this._parent.rotateX(this._axisLblRotation.x);
            this._parent.rotateY(this._axisLblRotation.y);
            this._parent.text(String.valueOf(this._label), 0.0f, 0.25f * (float)_font.getSize(), 0.0f);
            this._parent.popMatrix();
        }
        this._parent.popStyle();
    }
}

