/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph2D.traces;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import org.gwoptics.graphics.graph2D.traces.ILine2DEquation;
import org.gwoptics.graphics.graph2D.traces.Line2DTrace;
import org.gwoptics.graphics.graph2D.traces.Trace2DException;
import processing.core.PApplet;

public class UpdatingLine2DTrace
extends Line2DTrace {
    protected ReentrantLock _lock;
    protected boolean _doDraw;
    protected Timer _timer;
    protected long _refreshRate;
    protected float _xTickIncr;
    protected boolean _isMaster;
    protected UpdatingLine2DTrace[] _slaveTraces;
    protected double _drawPoint;

    protected boolean isMaster() {
        return this._isMaster;
    }

    public long getRefreshRate() {
        return this._refreshRate;
    }

    public UpdatingLine2DTrace(ILine2DEquation iLine2DEquation, long l, float f) {
        super(iLine2DEquation);
        this._xTickIncr = f;
        this._refreshRate = l;
        this._timer = new Timer();
        this._isMaster = true;
        this._lock = new ReentrantLock();
        this._slaveTraces = new UpdatingLine2DTrace[0];
        this._drawPoint = 0.0;
    }

    @Override
    public void setParent(PApplet pApplet) {
        super.setParent(pApplet);
        pApplet.registerMethod("pre", (Object)this);
    }

    @Override
    public void onAddTrace(Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            for (Object object : objectArray) {
                if (object instanceof UpdatingLine2DTrace) {
                    this._isMaster = false;
                    UpdatingLine2DTrace updatingLine2DTrace = (UpdatingLine2DTrace)object;
                    if (updatingLine2DTrace.isMaster()) {
                        updatingLine2DTrace._addTraceToMaster(this);
                    }
                    if (updatingLine2DTrace.getRefreshRate() == this._refreshRate) continue;
                    throw new Trace2DException("The refresh rate of this trace must be the same as the refresh rate of the Updating2DTraces already present in the Graph2D object.");
                }
                throw new Trace2DException("There are other types of traces that are not Updating2DTraces, remove before using a Updating2DTrace.");
            }
        }
        if (this._isMaster) {
            this._slaveTraces = new UpdatingLine2DTrace[0];
            this._timer.schedule((TimerTask)new RollingTick(), this._refreshRate);
        } else if (this._timer != null) {
            this._timer.cancel();
            this._timer = null;
        }
    }

    @Override
    public void onRemoveTrace() {
        if (this._isMaster && this._slaveTraces != null && this._slaveTraces.length > 0) {
            UpdatingLine2DTrace._changeMasterTrace(this, this._slaveTraces[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void _changeMasterTrace(UpdatingLine2DTrace updatingLine2DTrace, UpdatingLine2DTrace updatingLine2DTrace2) {
        if (updatingLine2DTrace.isMaster() && !updatingLine2DTrace2.isMaster()) {
            try {
                updatingLine2DTrace._lock.lock();
                updatingLine2DTrace2._lock.lock();
                updatingLine2DTrace._removeTraceFromMaster(updatingLine2DTrace2);
                updatingLine2DTrace._isMaster = false;
                updatingLine2DTrace2._isMaster = true;
                updatingLine2DTrace2._drawPoint = updatingLine2DTrace._drawPoint;
                updatingLine2DTrace2._slaveTraces = updatingLine2DTrace._slaveTraces;
                updatingLine2DTrace2._timer = new Timer();
                updatingLine2DTrace2._timer.schedule((TimerTask)updatingLine2DTrace2.new RollingTick(), updatingLine2DTrace2._refreshRate);
            }
            finally {
                updatingLine2DTrace._lock.unlock();
                updatingLine2DTrace2._lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void _addTraceToMaster(UpdatingLine2DTrace updatingLine2DTrace) {
        if (!this._isMaster || updatingLine2DTrace == null) return;
        UpdatingLine2DTrace[] updatingLine2DTraceArray = this._slaveTraces;
        synchronized (this._slaveTraces) {
            UpdatingLine2DTrace[] updatingLine2DTraceArray2 = new UpdatingLine2DTrace[this._slaveTraces.length + 1];
            System.arraycopy(this._slaveTraces, 0, updatingLine2DTraceArray2, 0, this._slaveTraces.length);
            updatingLine2DTraceArray2[updatingLine2DTraceArray2.length - 1] = updatingLine2DTrace;
            this._slaveTraces = new UpdatingLine2DTrace[updatingLine2DTraceArray2.length];
            System.arraycopy(updatingLine2DTraceArray2, 0, this._slaveTraces, 0, updatingLine2DTraceArray2.length);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void _removeTraceFromMaster(UpdatingLine2DTrace updatingLine2DTrace) {
        if (!this._isMaster || updatingLine2DTrace == null) return;
        UpdatingLine2DTrace[] updatingLine2DTraceArray = this._slaveTraces;
        synchronized (this._slaveTraces) {
            UpdatingLine2DTrace[] updatingLine2DTraceArray2 = new UpdatingLine2DTrace[this._slaveTraces.length];
            int n = 0;
            for (UpdatingLine2DTrace updatingLine2DTrace2 : this._slaveTraces) {
                if (updatingLine2DTrace.equals(updatingLine2DTrace2)) continue;
                updatingLine2DTraceArray2[n] = updatingLine2DTrace2;
                ++n;
            }
            if (updatingLine2DTraceArray2[this._slaveTraces.length - 1] != null) return;
            this._slaveTraces = new UpdatingLine2DTrace[updatingLine2DTraceArray2.length - 1];
            for (int i = 0; i < updatingLine2DTraceArray2.length - 1; ++i) {
                this._slaveTraces[i] = updatingLine2DTraceArray2[i];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void generate() {
        if (this._ax == null || this._ay == null) {
            throw new RuntimeException("One of the axis objects are null, set them using setAxes().");
        }
        int n = this._ax.valueToPosition(this._drawPoint);
        for (int i = 0; i < this._pointData.length; ++i) {
            if (i == n) {
                this._eqDataY[i] = this._cb.computePoint(this._drawPoint, i);
                this._pointData[i] = this._ay.valueToPosition((float)this._eqDataY[i]);
                continue;
            }
            if (i <= n) continue;
            this._eqDataY[i] = Double.NaN;
            this._pointData[i] = Float.NaN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pre() {
        try {
            this._lock.lock();
            if (this._isMaster && this._doDraw) {
                this.generate();
                for (UpdatingLine2DTrace updatingLine2DTrace : this._slaveTraces) {
                    if (updatingLine2DTrace == null) continue;
                    updatingLine2DTrace.generate();
                }
                this._doDraw = false;
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public void draw() {
        super.draw();
    }

    protected class RollingTick
    extends TimerTask {
        protected RollingTick() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (UpdatingLine2DTrace.this._isMaster) {
                try {
                    UpdatingLine2DTrace.this._lock.lock();
                    UpdatingLine2DTrace.this._drawPoint += (double)UpdatingLine2DTrace.this._xTickIncr;
                    if (UpdatingLine2DTrace.this._drawPoint > (double)UpdatingLine2DTrace.this._ax.getMaxValue()) {
                        double d = UpdatingLine2DTrace.this._ax.getMaxValue() - UpdatingLine2DTrace.this._ax.getMinValue();
                        UpdatingLine2DTrace.this._ax.setMinValue((float)((double)UpdatingLine2DTrace.this._ax.getMinValue() + d));
                        UpdatingLine2DTrace.this._ax.setMaxValue((float)((double)UpdatingLine2DTrace.this._ax.getMaxValue() + d));
                        int n = UpdatingLine2DTrace.this._ax.valueToPosition(UpdatingLine2DTrace.this._drawPoint);
                        if (n < 0) {
                            UpdatingLine2DTrace.this._drawPoint = UpdatingLine2DTrace.this._ax.positionToValue(0);
                        } else if (n > 0) {
                            for (int i = 0; i < n; ++i) {
                                UpdatingLine2DTrace.this._pointData[i] = Float.NaN;
                                UpdatingLine2DTrace.this._eqDataY[i] = Double.NaN;
                            }
                        }
                    }
                    for (UpdatingLine2DTrace updatingLine2DTrace : UpdatingLine2DTrace.this._slaveTraces) {
                        updatingLine2DTrace._drawPoint = UpdatingLine2DTrace.this._drawPoint;
                    }
                    UpdatingLine2DTrace.this._doDraw = true;
                    UpdatingLine2DTrace.this._timer.schedule((TimerTask)new RollingTick(), UpdatingLine2DTrace.this._refreshRate);
                }
                finally {
                    UpdatingLine2DTrace.this._lock.unlock();
                }
            }
        }
    }
}

