/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph2D.traces;

import java.util.ArrayList;
import java.util.HashMap;
import org.gwoptics.graphics.GWColour;
import org.gwoptics.graphics.graph2D.traces.Blank2DTrace;
import processing.core.PFont;

public class ScatterTrace
extends Blank2DTrace {
    private ArrayList<LabelData> _labels;
    private ArrayList<Point2D> _data;
    private ArrayList<HashMap<String, Object>> _info;
    private GWColour defaultColour = new GWColour(255, 0, 0);
    private GWColour defaultLabelColour = new GWColour(0, 0, 0);
    private float defaultSize = 0.05f;
    private IScatterPoint _pt;
    private PFont _labelfont;
    private LABELPOSITION _lblPos = LABELPOSITION.RIGHT;
    public static final IScatterPoint Cross = new IScatterPoint(){

        @Override
        public void drawPoint(float f, float f2, Blank2DTrace.PlotRenderer plotRenderer, HashMap<String, Object> hashMap) {
            float f3 = 0.5f * ((Number)hashMap.get("size")).floatValue();
            GWColour gWColour = (GWColour)hashMap.get("colour");
            plotRenderer.canvas.pushStyle();
            plotRenderer.canvas.stroke(gWColour.toInt());
            plotRenderer.canvas.strokeCap(1);
            float f4 = plotRenderer.valToX(f);
            float f5 = plotRenderer.valToY(f2);
            plotRenderer.canvas.line(f4 - f3, f5, f4 + f3, f5);
            plotRenderer.canvas.line(f4, f5 - f3, f4, f5 + f3);
            plotRenderer.canvas.popStyle();
        }
    };
    public static final IScatterPoint Circle = new IScatterPoint(){

        @Override
        public void drawPoint(float f, float f2, Blank2DTrace.PlotRenderer plotRenderer, HashMap<String, Object> hashMap) {
            float f3 = 0.5f * ((Number)hashMap.get("size")).floatValue();
            GWColour gWColour = (GWColour)hashMap.get("colour");
            f = plotRenderer.valToX(f);
            f2 = plotRenderer.valToY(f2);
            plotRenderer.canvas.fill(gWColour.toInt());
            plotRenderer.canvas.noStroke();
            plotRenderer.canvas.ellipse(f, f2, f3, f3);
        }
    };
    public static final IScatterPoint Ring = new IScatterPoint(){

        @Override
        public void drawPoint(float f, float f2, Blank2DTrace.PlotRenderer plotRenderer, HashMap<String, Object> hashMap) {
            float f3 = 0.5f * ((Number)hashMap.get("size")).floatValue();
            GWColour gWColour = (GWColour)hashMap.get("colour");
            float f4 = 1.0f;
            if (hashMap.containsKey("stroke")) {
                f4 = ((Float)hashMap.get("stroke")).floatValue();
            }
            f = plotRenderer.valToX(f);
            f2 = plotRenderer.valToY(f2);
            plotRenderer.canvas.pushStyle();
            plotRenderer.canvas.stroke(gWColour.toInt());
            plotRenderer.canvas.strokeWeight(f4);
            plotRenderer.canvas.noFill();
            plotRenderer.canvas.ellipse(f, f2, f3, f3);
            plotRenderer.canvas.popStyle();
        }
    };

    public ScatterTrace(IScatterPoint iScatterPoint) {
        this._pt = iScatterPoint;
        this._labels = new ArrayList();
        this._info = new ArrayList();
        this._data = new ArrayList();
    }

    @Override
    public void onAddTrace(Object[] objectArray) {
        if (this._labelfont == null) {
            this._labelfont = this._parent.createFont("Arial", 12.0f, true);
        }
    }

    public void setLablePosition(LABELPOSITION lABELPOSITION) {
        this._lblPos = lABELPOSITION;
    }

    public void setLabelFont(PFont pFont) {
        if (pFont == null) {
            throw new NullPointerException("Font object cannot be null");
        }
        this._labelfont = pFont;
    }

    public void setDefaultLabelColor(GWColour gWColour) {
        if (gWColour == null) {
            throw new NullPointerException("Color object cannot be null");
        }
        this.defaultLabelColour = gWColour;
    }

    public void setDefaultColor(GWColour gWColour) {
        if (gWColour == null) {
            throw new NullPointerException("Color object cannot be null");
        }
        this.defaultColour = gWColour;
    }

    public void setDefaultSize(float f) {
        this.defaultSize = Math.abs(f);
    }

    private void _addPoint(float f, float f2, float f3, GWColour gWColour) {
        this._data.add(new Point2D(f, f2));
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        if (!hashMap.containsKey("color")) {
            hashMap.put("colour", gWColour);
        }
        if (!hashMap.containsKey("size")) {
            hashMap.put("size", Float.valueOf(f3));
        }
        this._info.add(hashMap);
    }

    public void addPoint(float f, float f2, float f3, GWColour gWColour, Object ... objectArray) {
        this._addPoint(f, f2, f3, gWColour);
        this._processesVarArgs(objectArray);
    }

    public void addPoint(float f, float f2, Object ... objectArray) {
        this._addPoint(f, f2, this.defaultSize, this.defaultColour);
        this._processesVarArgs(objectArray);
    }

    public void addPoint(float f, float f2, float f3, String string, GWColour gWColour, Object ... objectArray) {
        if (objectArray.length % 2 != 0) {
            throw new RuntimeException("There was not an even number of Key/Value pairs");
        }
        this._addPoint(f, f2, f3, gWColour);
        this._processesVarArgs(objectArray);
    }

    protected void _processesVarArgs(Object[] objectArray) {
        HashMap<String, Object> hashMap = this._info.get(this._info.size() - 1);
        for (int i = 0; i < objectArray.length; i += 2) {
            if (!(objectArray[i] instanceof String)) {
                throw new RuntimeException("Was expecting vararg number " + i + " to be a string for a key value");
            }
            String string = (String)objectArray[i];
            if (string.compareToIgnoreCase("label") == 0) {
                if (!(objectArray[i + 1] instanceof String)) {
                    throw new RuntimeException("Was expecting label value to be a string");
                }
                if (this._labels.size() < this._info.size()) {
                    this._labels.add(new LabelData());
                }
                this._labels.get((int)(this._info.size() - 1)).value = (String)objectArray[i + 1];
            } else if (string.compareToIgnoreCase("labelcolour") == 0 || string.compareToIgnoreCase("labelcolor") == 0) {
                if (!(objectArray[i + 1] instanceof GWColour)) {
                    throw new RuntimeException("Was expecting labelcolor value to be a GWColor object");
                }
                if (this._labels.size() < this._info.size()) {
                    this._labels.add(new LabelData());
                }
                this._labels.get((int)(this._info.size() - 1)).c = (GWColour)objectArray[i + 1];
            } else if (string.compareToIgnoreCase("labeloffsetscale") == 0) {
                if (this._labels.size() < this._info.size()) {
                    this._labels.add(new LabelData());
                }
                this._labels.get((int)(this._info.size() - 1)).offscale = ((Number)objectArray[i + 1]).floatValue();
            }
            hashMap.put((String)objectArray[i], objectArray[i + 1]);
        }
    }

    private void drawPoint(int n, Blank2DTrace.PlotRenderer plotRenderer) {
        Point2D point2D = this._data.get(n);
        plotRenderer.canvas.pushMatrix();
        plotRenderer.canvas.pushStyle();
        this._pt.drawPoint(point2D.x, point2D.y, plotRenderer, this._info.get(n));
        plotRenderer.canvas.popMatrix();
        plotRenderer.canvas.popStyle();
        if (!this._labels.isEmpty()) {
            plotRenderer.canvas.pushMatrix();
            plotRenderer.canvas.pushStyle();
            plotRenderer.canvas.scale(1.0f, -1.0f);
            plotRenderer.canvas.textFont(this._labelfont);
            plotRenderer.canvas.fill(0);
            float f = 0.0f;
            float f2 = 0.0f;
            String string = this._labels.get((int)n).value;
            GWColour gWColour = this._labels.get((int)n).c;
            float f3 = this._labels.get((int)n).offscale;
            switch (this._lblPos) {
                case CENTER: {
                    f = -plotRenderer.canvas.textWidth(string) / 2.0f;
                    f2 = (float)(-this._labelfont.getSize()) * this._labelfont.ascent() / 2.0f;
                    break;
                }
                case BELOW: {
                    f = -plotRenderer.canvas.textWidth(string) / 2.0f;
                    f2 = -this.defaultSize * f3 / 2.0f - (float)this._labelfont.getSize() * this._labelfont.ascent();
                    break;
                }
                case ABOVE: {
                    f = -plotRenderer.canvas.textWidth(string) / 2.0f;
                    f2 = this.defaultSize * f3 / 2.0f + (float)this._labelfont.getSize() * this._labelfont.descent();
                    break;
                }
                case LEFT: {
                    f2 = (float)(-this._labelfont.getSize()) * this._labelfont.ascent() / 2.0f;
                    f = -(plotRenderer.canvas.textWidth(string) + this.defaultSize * f3 / 2.0f);
                    break;
                }
                case RIGHT: {
                    f2 = (float)(-this._labelfont.getSize()) * this._labelfont.ascent() / 2.0f;
                    f = this.defaultSize * f3 / 2.0f;
                }
            }
            plotRenderer.canvas.fill(gWColour.toInt());
            plotRenderer.canvas.text(string, plotRenderer.valToX(point2D.x) + f, -(plotRenderer.valToY(point2D.y) + f2));
            plotRenderer.canvas.popMatrix();
            plotRenderer.canvas.popStyle();
        }
    }

    @Override
    public void TraceDraw(Blank2DTrace.PlotRenderer plotRenderer) {
        plotRenderer.canvas.pushStyle();
        plotRenderer.canvas.pushMatrix();
        if (this._data != null) {
            for (int i = 0; i < this._data.size(); ++i) {
                this.drawPoint(i, plotRenderer);
            }
        }
        plotRenderer.canvas.popMatrix();
        plotRenderer.canvas.popStyle();
    }

    static /* synthetic */ GWColour access$000(ScatterTrace scatterTrace) {
        return scatterTrace.defaultLabelColour;
    }

    public static interface IScatterPoint {
        public void drawPoint(float var1, float var2, Blank2DTrace.PlotRenderer var3, HashMap<String, Object> var4);
    }

    private class Point2D {
        public float x;
        public float y;

        public Point2D(float f, float f2) {
            this.x = f;
            this.y = f2;
        }
    }

    private class LabelData {
        public String value = "";
        public GWColour c = ScatterTrace.access$000(ScatterTrace.this);
        public float offscale = 1.0f;

        private LabelData() {
        }
    }

    public static enum LABELPOSITION {
        ABOVE,
        LEFT,
        RIGHT,
        BELOW,
        CENTER;

    }
}

