/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph2D.traces;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import org.gwoptics.graphics.graph2D.IGraph2D;
import org.gwoptics.graphics.graph2D.traces.ILine2DEquation;
import org.gwoptics.graphics.graph2D.traces.Line2DTrace;
import org.gwoptics.graphics.graph2D.traces.Trace2DException;
import processing.core.PApplet;

public class RollingLine2DTrace
extends Line2DTrace {
    protected ReentrantLock _lock;
    protected boolean _doDraw;
    protected Timer _timer;
    protected long _refreshRate;
    protected float _xIncr;
    protected boolean _isMaster;
    protected RollingLine2DTrace[] _slaveTraces;
    protected double[] _eqDataX;
    protected boolean paused = false;

    public void pause() {
        this.paused = true;
        this._timer.cancel();
    }

    public void unpause() {
        if (this.paused) {
            this.paused = false;
            this._timer = new Timer();
            this._timer.schedule((TimerTask)new RollingTick(), this._refreshRate);
        }
    }

    public long getRefreshRate() {
        return this._refreshRate;
    }

    protected boolean isMaster() {
        return this._isMaster;
    }

    public RollingLine2DTrace(ILine2DEquation iLine2DEquation, long l, float f) {
        super(iLine2DEquation);
        this._refreshRate = l;
        this._xIncr = f;
        this._timer = new Timer();
        this._isMaster = true;
        this._lock = new ReentrantLock();
        this._slaveTraces = new RollingLine2DTrace[0];
    }

    @Override
    public void setParent(PApplet pApplet) {
        super.setParent(pApplet);
        pApplet.registerMethod("pre", (Object)this);
    }

    @Override
    public void setGraph(IGraph2D iGraph2D) {
        super.setGraph(iGraph2D);
        this._eqDataX = new double[this._ax.getLength()];
        for (int i = 0; i < this._eqDataX.length; ++i) {
            this._eqDataX[i] = this._ax.positionToValue(i);
            this._eqDataY[i] = Double.NaN;
            if (i <= 0 || !(this._eqDataX[i] <= this._eqDataX[i - 1])) continue;
            PApplet.println((String)"length of the X-Axis and the range of values used is conflicting so that 2 pixels on the X-Axis have the same value. Please change the axis range or length of graph");
        }
    }

    @Override
    public void onAddTrace(Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            for (Object object : objectArray) {
                if (object instanceof RollingLine2DTrace) {
                    this._isMaster = false;
                    RollingLine2DTrace rollingLine2DTrace = (RollingLine2DTrace)object;
                    if (rollingLine2DTrace.isMaster()) {
                        rollingLine2DTrace._addTraceToMaster(this);
                    }
                    if (rollingLine2DTrace.getRefreshRate() == this._refreshRate) continue;
                    throw new Trace2DException("The refresh rate of this trace must be the same as the refresh rate of the Rolling2DTraces already present in the Graph2D object.");
                }
                throw new Trace2DException("There are other types of traces that are not Rolling2DTraces, remove before using a Rolling2DTrace.");
            }
        }
        if (this._isMaster) {
            this._slaveTraces = new RollingLine2DTrace[0];
            this._timer.schedule((TimerTask)new RollingTick(), this._refreshRate);
        } else if (this._timer != null) {
            this._timer.cancel();
            this._timer = null;
        }
    }

    @Override
    public void onRemoveTrace() {
        if (this._isMaster && this._slaveTraces != null && this._slaveTraces.length > 0) {
            RollingLine2DTrace._changeMasterTrace(this, this._slaveTraces[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _changeMasterTrace(RollingLine2DTrace rollingLine2DTrace, RollingLine2DTrace rollingLine2DTrace2) {
        if (rollingLine2DTrace.isMaster() && !rollingLine2DTrace2.isMaster()) {
            try {
                rollingLine2DTrace._lock.lock();
                rollingLine2DTrace2._lock.lock();
                rollingLine2DTrace._removeTraceFromMaster(rollingLine2DTrace2);
                rollingLine2DTrace._isMaster = false;
                rollingLine2DTrace2._isMaster = true;
                rollingLine2DTrace2._slaveTraces = rollingLine2DTrace._slaveTraces;
                rollingLine2DTrace2._timer = new Timer();
                rollingLine2DTrace2._timer.schedule((TimerTask)rollingLine2DTrace2.new RollingTick(), rollingLine2DTrace2._refreshRate);
            }
            finally {
                rollingLine2DTrace._lock.unlock();
                rollingLine2DTrace2._lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void _addTraceToMaster(RollingLine2DTrace rollingLine2DTrace) {
        if (!this._isMaster || rollingLine2DTrace == null) return;
        RollingLine2DTrace[] rollingLine2DTraceArray = this._slaveTraces;
        synchronized (this._slaveTraces) {
            RollingLine2DTrace[] rollingLine2DTraceArray2 = new RollingLine2DTrace[this._slaveTraces.length + 1];
            System.arraycopy(this._slaveTraces, 0, rollingLine2DTraceArray2, 0, this._slaveTraces.length);
            rollingLine2DTraceArray2[rollingLine2DTraceArray2.length - 1] = rollingLine2DTrace;
            this._slaveTraces = new RollingLine2DTrace[rollingLine2DTraceArray2.length];
            System.arraycopy(rollingLine2DTraceArray2, 0, this._slaveTraces, 0, rollingLine2DTraceArray2.length);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void _removeTraceFromMaster(RollingLine2DTrace rollingLine2DTrace) {
        if (!this._isMaster || rollingLine2DTrace == null) return;
        RollingLine2DTrace[] rollingLine2DTraceArray = this._slaveTraces;
        synchronized (this._slaveTraces) {
            RollingLine2DTrace[] rollingLine2DTraceArray2 = new RollingLine2DTrace[this._slaveTraces.length];
            int n = 0;
            for (RollingLine2DTrace rollingLine2DTrace2 : this._slaveTraces) {
                if (rollingLine2DTrace.equals(rollingLine2DTrace2)) continue;
                rollingLine2DTraceArray2[n] = rollingLine2DTrace2;
                ++n;
            }
            if (rollingLine2DTraceArray2[this._slaveTraces.length - 1] != null) return;
            this._slaveTraces = new RollingLine2DTrace[rollingLine2DTraceArray2.length - 1];
            for (int i = 0; i < rollingLine2DTraceArray2.length - 1; ++i) {
                this._slaveTraces[i] = rollingLine2DTraceArray2[i];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void generate() {
        int n;
        if (this._ax == null || this._ay == null) {
            throw new RuntimeException("One of the axis objects are null, set them using setAxes().");
        }
        int n2 = this._eqDataY.length - 1;
        int n3 = this._ax.valueToPosition(this._eqDataX[n2]);
        int n4 = n2 - n3;
        if (n4 >= this._eqDataX.length) {
            throw new RollingTraceTooFastException();
        }
        int n5 = n4 - this._ax.valueToPosition(this._eqDataX[n4]);
        for (n = n4; n <= n2; ++n) {
            int n6 = this._ax.valueToPosition(this._eqDataX[n]);
            if (n - n6 != n5) {
                n6 = n - n5;
                this._eqDataX[n] = this._ax.positionToValue(n6);
            }
            if (!(n6 >= 0 & n6 != n)) continue;
            this._eqDataX[n6] = this._eqDataX[n];
            this._eqDataY[n6] = this._eqDataY[n];
            this._eqDataY[n] = Double.NaN;
        }
        if (n3 < n2) {
            for (n = n3 + 1; n <= n2; ++n) {
                float f = this._ax.positionToValue(n);
                this._eqDataX[n] = f;
                this._eqDataY[n] = Double.NaN;
            }
        }
        this._eqDataX[n2] = this._ax.getMaxValue();
        this._eqDataY[n2] = this._cb.computePoint(this._eqDataX[n2], n2);
        for (n = 0; n < this._pointData.length; ++n) {
            this._pointData[n] = Double.isNaN(this._eqDataY[n]) ? Float.NaN : (float)this._ay.valueToPosition((float)this._eqDataY[n]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pre() {
        try {
            this._lock.lock();
            if (this._isMaster && this._doDraw) {
                this.generate();
                for (RollingLine2DTrace rollingLine2DTrace : this._slaveTraces) {
                    if (rollingLine2DTrace == null) continue;
                    rollingLine2DTrace.generate();
                }
                this._doDraw = false;
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    protected class RollingTick
    extends TimerTask {
        protected RollingTick() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (RollingLine2DTrace.this._isMaster) {
                try {
                    RollingLine2DTrace.this._lock.lock();
                    RollingLine2DTrace.this._doDraw = true;
                    if (RollingLine2DTrace.this.isMaster()) {
                        RollingLine2DTrace.this._ax.setMaxValue(RollingLine2DTrace.this._ax.getMaxValue() + RollingLine2DTrace.this._xIncr);
                        RollingLine2DTrace.this._ax.setMinValue(RollingLine2DTrace.this._ax.getMinValue() + RollingLine2DTrace.this._xIncr);
                    }
                    if (!RollingLine2DTrace.this.paused) {
                        RollingLine2DTrace.this._timer.schedule((TimerTask)new RollingTick(), RollingLine2DTrace.this._refreshRate);
                    }
                }
                finally {
                    RollingLine2DTrace.this._lock.unlock();
                }
            }
        }
    }

    public class RollingTraceTooFastException
    extends RuntimeException {
        public RollingTraceTooFastException() {
            super("The RollingGraphTrace is moving too fast to process and render correctly. You need to reduce the x-axis increment per update or use a larger refresh rate in the RollingLine2DTrace constructor");
        }
    }
}

