/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph2D.traces;

import org.gwoptics.graphics.GWColour;
import org.gwoptics.graphics.graph2D.Axis2D;
import org.gwoptics.graphics.graph2D.IGraph2D;
import org.gwoptics.graphics.graph2D.backgrounds.IGraph2DBackground;
import org.gwoptics.graphics.graph2D.effects.ITraceColourEffect;
import org.gwoptics.graphics.graph2D.traces.IGraph2DTrace;
import org.gwoptics.graphics.graph2D.traces.ILine2DEquation;
import processing.core.PApplet;
import processing.core.PVector;

public class Line2DTrace
implements IGraph2DTrace {
    protected Axis2D _ax;
    protected Axis2D _ay;
    protected IGraph2DBackground _back;
    protected PApplet _parent;
    protected ILine2DEquation _cb;
    protected double[] _eqDataY;
    protected float[] _pointData;
    protected boolean _yAutoRange;
    protected PVector _pos;
    protected GWColour _traceColour;
    protected ITraceColourEffect _effect;
    protected int _lineWidth;

    public Line2DTrace(ILine2DEquation iLine2DEquation) {
        this._cb = iLine2DEquation;
        this._pos = new PVector(0.0f, 0.0f);
        this._traceColour = new GWColour(0, 0, 0);
    }

    @Override
    public void setGraph(IGraph2D iGraph2D) {
        this._ax = iGraph2D.getXAxis();
        this._ay = iGraph2D.getYAxis();
        this._setupTraceEffect();
        this._back = iGraph2D.getGraphBackground();
        this._pointData = new float[this._ax.getLength()];
        this._eqDataY = new double[this._ax.getLength()];
    }

    @Override
    public void setParent(PApplet pApplet) {
        if (pApplet == null) {
            throw new NullPointerException("Parent object can not be null");
        }
        this._parent = pApplet;
    }

    @Override
    public void setPosition(int n, int n2) {
        this._pos.x = n;
        this._pos.y = n2;
    }

    public void setEquationCallback(ILine2DEquation iLine2DEquation) {
        this._cb = iLine2DEquation;
    }

    @Override
    public void generate() {
        if (this._ax == null || this._ay == null) {
            throw new RuntimeException("One of the axis objects are null, set them using setAxes().");
        }
        if (this._cb != null) {
            int n;
            double d = 0.0;
            double d2 = 0.0;
            for (n = 0; n < this._eqDataY.length; ++n) {
                double d3;
                double d4 = this._ax.positionToValue(n);
                this._eqDataY[n] = d3 = this._cb.computePoint(d4, n);
                if (this._yAutoRange) {
                    if (d3 > d) {
                        d = d3;
                        continue;
                    }
                    if (!(d3 < d2)) continue;
                    d3 = d2;
                    continue;
                }
                this._pointData[n] = this._ay.valueToPosition((float)d3);
            }
            if (this._yAutoRange) {
                this._ay.setMinValue((float)d2);
                this._ay.setMaxValue((float)d);
                for (n = 0; n < this._eqDataY.length; ++n) {
                    this._pointData[n] = this._ay.valueToPosition((float)this._eqDataY[n]);
                }
            }
        }
    }

    @Override
    public void draw() {
        if (this._parent == null) {
            throw new NullPointerException("Set parent object before plotting.");
        }
        float f = (this._ax.getMaxValue() - this._ax.getMinValue()) / (float)(this._ax.getLength() - 1);
        this._parent.pushMatrix();
        this._parent.pushStyle();
        this._parent.translate(this._pos.x, this._pos.y);
        this._parent.strokeWeight((float)this._lineWidth);
        if (this._pointData.length > 0) {
            int n = 0;
            float f2 = 0.0f;
            int n2 = 0;
            for (int i = 0; i < this._pointData.length; ++i) {
                if (Float.isNaN(this._pointData[i])) continue;
                n = i;
                f2 = this._pointData[i];
                n2 = i + 1;
                break;
            }
            if (n2 != 0) {
                float f3 = 0.0f;
                f2 = this._pointData[n2 - 1];
                for (int i = n2; i < this._pointData.length; ++i) {
                    f3 = this._pointData[i];
                    if (Float.isNaN(f3) || Float.isNaN(f2)) continue;
                    boolean bl = false;
                    if (f3 < 0.0f || f3 > (float)this._ay.getLength()) {
                        bl = true;
                    }
                    if (f2 < 0.0f || f2 > (float)this._ay.getLength()) {
                        bl = true;
                    }
                    if (!bl) {
                        if (this._effect != null) {
                            GWColour gWColour = this._effect.getPixelColour(i - 1, (int)f3, this._ax.getMinValue() + (float)i * f, (float)this._eqDataY[i - 1]);
                            this._parent.stroke(gWColour.R * 255.0f, gWColour.G * 255.0f, gWColour.B * 255.0f, gWColour.A * 255.0f);
                        } else {
                            this._parent.stroke(this._traceColour.R * 255.0f, this._traceColour.G * 255.0f, this._traceColour.B * 255.0f, this._traceColour.A * 255.0f);
                        }
                    } else {
                        this._parent.stroke(0, 0.0f);
                    }
                    this._parent.line((float)n, -f2, (float)i, -f3);
                    n = i;
                    f2 = f3;
                }
            }
        }
        this._parent.popStyle();
        this._parent.popMatrix();
    }

    @Override
    public void onAddTrace(Object[] objectArray) {
    }

    @Override
    public void onRemoveTrace() {
    }

    public void setTraceColour(int n, int n2, int n3) {
        this._traceColour = new GWColour(n, n2, n3);
    }

    public void setLineWidth(int n) {
        this._lineWidth = n;
    }

    public void removeEffect() {
        this._effect = null;
    }

    public void setTraceEffect(ITraceColourEffect iTraceColourEffect) {
        this._effect = iTraceColourEffect;
        this._setupTraceEffect();
    }

    private void _setupTraceEffect() {
        if (this._ax != null && this._ay != null && this._effect != null) {
            this._effect.setXAxisValues(this._ax.getLength(), this._ax.getMinValue(), this._ax.getMaxValue());
            this._effect.setYAxisValues(this._ay.getLength(), this._ay.getMinValue(), this._ay.getMaxValue());
        }
    }
}

