/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph2D.traces;

import org.gwoptics.graphics.graph2D.Axis2D;
import org.gwoptics.graphics.graph2D.IGraph2D;
import org.gwoptics.graphics.graph2D.traces.IGraph2DTrace;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;

public abstract class Blank2DTrace
implements IGraph2DTrace {
    private IGraph2D _graphDrawable;
    protected PApplet _parent;
    protected PGraphics _backBuffer;
    protected PImage _traceImg;
    private boolean _redraw;
    private String _renderer = "processing.opengl.PGraphics2D";
    protected PlotRenderer _prenderer;

    protected IGraph2D getGraph() {
        return this._graphDrawable;
    }

    public final void setRenderer(String string) {
        if (!string.equals("processing.core.PGraphicsJava2D") & !string.equals("processing.opengl.PGraphics2D") & !string.equals("processing.opengl.PGraphics3D")) {
            throw new RuntimeException("Renderer must be JAVA2D, P2D or OPENGL");
        }
        this._renderer = string;
    }

    @Override
    public void generate() {
        this._redraw = true;
    }

    @Override
    public void onAddTrace(Object[] objectArray) {
    }

    @Override
    public void onRemoveTrace() {
    }

    @Override
    public void setPosition(int n, int n2) {
    }

    @Override
    public void setParent(PApplet pApplet) {
        if (pApplet == null) {
            throw new NullPointerException("Cannot assign a null PApplet object as a parent.");
        }
        this._parent = pApplet;
    }

    @Override
    public void setGraph(IGraph2D iGraph2D) {
        if (iGraph2D == null) {
            throw new NullPointerException("Cannot assign a null graph2D object to draw on.");
        }
        if (this._graphDrawable != null) {
            throw new RuntimeException("A Graph2D object has already been set for this trace, other components may have already referenced the previous Graphs objects.");
        }
        if (this._parent == null) {
            throw new NullPointerException("Parent PApplet object is null.");
        }
        this._graphDrawable = iGraph2D;
        this._backBuffer = this._parent.createGraphics(iGraph2D.getXAxis().getLength(), iGraph2D.getYAxis().getLength(), this._renderer);
        this._prenderer = new PlotRenderer(iGraph2D, this._backBuffer);
    }

    @Override
    public void draw() {
        if (this._redraw) {
            this._backBuffer.beginDraw();
            this._prenderer.update();
            Axis2D axis2D = this._graphDrawable.getXAxis();
            Axis2D axis2D2 = this._graphDrawable.getYAxis();
            float f = axis2D.valueToPosition(0.0f);
            float f2 = this._backBuffer.height - axis2D2.valueToPosition(0.0f);
            this._backBuffer.translate(f, f2);
            this._backBuffer.pushMatrix();
            this._backBuffer.scale(1.0f, -1.0f);
            this._backBuffer.background(0.0f, 0.0f, 0.0f, 0.0f);
            this._backBuffer.strokeCap(1);
            this.TraceDraw(this._prenderer);
            this._backBuffer.popMatrix();
            this._backBuffer.endDraw();
            this._traceImg = this._backBuffer.get(0, 0, this._backBuffer.width, this._backBuffer.height);
            this._redraw = false;
        }
        if (this._traceImg != null) {
            this._parent.image(this._traceImg, 0.0f, (float)(-this._backBuffer.height));
        }
    }

    public abstract void TraceDraw(PlotRenderer var1);

    public class PlotRenderer {
        public PGraphics canvas;
        private Axis2D _x;
        private Axis2D _y;
        private float _offx;
        private float _offy;

        public PlotRenderer(IGraph2D iGraph2D, PGraphics pGraphics) {
            this.canvas = pGraphics;
            this._x = iGraph2D.getXAxis();
            this._y = iGraph2D.getYAxis();
        }

        protected void update() {
            this._offx = this._x.valueToPosition(0.0f);
            this._offy = this._y.valueToPosition(0.0f);
        }

        public float valToX(double d) {
            return (float)this._x.valueToPosition(d) - this._offx;
        }

        public float valToY(double d) {
            return (float)this._y.valueToPosition(d) - this._offy;
        }
    }
}

