/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph2D.effects;

import org.gwoptics.graphics.GWColour;
import org.gwoptics.graphics.colourmap.IColourmap;
import org.gwoptics.graphics.graph2D.effects.AxisColourmapEffect;

public class XAxisColourmapEffect
extends AxisColourmapEffect {
    public XAxisColourmapEffect(IColourmap iColourmap) {
        super(iColourmap);
    }

    @Override
    public GWColour getPixelColour(int n, int n2, float f, float f2) {
        if (!this._xaxisDataSet || !this._yaxisDataSet) {
            throw new RuntimeException("Axis data has not been set. Set using setXAxisValues and setYAxisValues before using.");
        }
        if (this._map.isCentreAtZero()) {
            if (this.xContainsZero) {
                float f3 = Math.max(Math.abs(this.xMax), Math.abs(this.xMin));
                return this._map.getColourAtLocation(1.0f - Math.abs(f - f3) / (f3 * 2.0f));
            }
            float f4 = this.yMax - this.yMin;
            if (Math.signum(f4) == 1.0f) {
                return this._map.getColourAtLocation(0.5f + (float)((double)(f - this.xMin) * 0.5 / (double)f4));
            }
            if (Math.signum(f4) == -1.0f) {
                return this._map.getColourAtLocation((float)((double)(f - this.xMin) * 0.5 / (double)f4));
            }
        } else {
            return this._map.getColourAtLocation(Math.abs((f - this.xMin) / (this.xMax - this.xMin)));
        }
        return new GWColour(0, 0, 0);
    }
}

