/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph2D;

import java.util.ArrayList;
import org.gwoptics.graphics.GWColour;
import org.gwoptics.graphics.Renderable;
import org.gwoptics.graphics.graph2D.Axis2D;
import org.gwoptics.graphics.graph2D.IGraph2D;
import org.gwoptics.graphics.graph2D.LabelPos;
import org.gwoptics.graphics.graph2D.backgrounds.IGraph2DBackground;
import org.gwoptics.graphics.graph2D.traces.IGraph2DTrace;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PVector;

public class Graph2D
extends Renderable
implements PConstants,
IGraph2D {
    protected Axis2D _ax;
    protected Axis2D _ay;
    protected float _xLength;
    protected float _yLength;
    protected GWColour _border;
    protected ArrayList<IGraph2DTrace> _traces;
    protected boolean _crossAxesAtZero;
    protected IGraph2DBackground _back;

    public void setXAxisTickSpacing(float f) {
        this._ax.setTickSpacing(f);
    }

    public void setYAxisTickSpacing(float f) {
        this._ay.setTickSpacing(f);
    }

    public void setXAxisMin(float f) {
        this._ax.setMinValue(f);
    }

    public void setXAxisMax(float f) {
        this._ax.setMaxValue(f);
    }

    public void setYAxisMin(float f) {
        this._ay.setMinValue(f);
    }

    public void setYAxisMax(float f) {
        this._ay.setMaxValue(f);
    }

    public void setXAxisLabel(String string) {
        this._ax.setAxisLabel(string);
    }

    public void setYAxisLabel(String string) {
        this._ay.setAxisLabel(string);
    }

    public void setXAxisLabelPos(LabelPos labelPos) {
        this._ax.setAxisLabelPos(labelPos);
    }

    public void setYAxisLabelPos(LabelPos labelPos) {
        this._ay.setAxisLabelPos(labelPos);
    }

    public void setXAxisLabelAccuracy(int n) {
        this._ax.setTickLabelAccuracy(n);
    }

    public void setYAxisLabelAccuracy(int n) {
        this._ay.setTickLabelAccuracy(n);
    }

    public void setXAxisMinorTicks(int n) {
        this._ax.setMinorTicks(n);
    }

    public void setXAxisLabelFont(String string, int n, boolean bl) {
        this._ax.setLabelFont(string, n, bl);
    }

    public void setXAxisTickFont(String string, int n, boolean bl) {
        this._ax.setTickFont(string, n, bl);
    }

    public void setYAxisLabelFont(String string, int n, boolean bl) {
        this._ay.setLabelFont(string, n, bl);
    }

    public void setYAxisTickFont(String string, int n, boolean bl) {
        this._ay.setTickFont(string, n, bl);
    }

    public void setYAxisMinorTicks(int n) {
        this._ay.setMinorTicks(n);
    }

    public void setAxisColour(int n, int n2, int n3) {
        this.setAxisColour(new GWColour(n, n2, n3));
    }

    public void setAxisColour(GWColour gWColour) {
        if (gWColour == null) {
            throw new NullPointerException("Colour argument cannot be null");
        }
        this._ax.setAxisColour(gWColour);
        this._ay.setAxisColour(gWColour);
    }

    public void setFontColour(int n, int n2, int n3) {
        this.setFontColour(new GWColour(n, n2, n3));
    }

    public void setFontColour(GWColour gWColour) {
        if (gWColour == null) {
            throw new NullPointerException("Colour argument cannot be null");
        }
        this._ax.setFontColour(gWColour);
        this._ay.setFontColour(gWColour);
    }

    @Override
    public IGraph2DBackground getGraphBackground() {
        return this._back;
    }

    @Override
    public Axis2D getXAxis() {
        return this._ax;
    }

    @Override
    public Axis2D getYAxis() {
        return this._ay;
    }

    public void setNoBorder() {
        this._border = null;
    }

    public void setNoBackground() {
        this._back = null;
    }

    public void setBorderColour(int n, int n2, int n3) {
        this._border = new GWColour(n, n2, n3);
    }

    public void setBackground(IGraph2DBackground iGraph2DBackground) {
        this._back = iGraph2DBackground;
        this._back.setParent(this._parent);
        this._back.setAxes(this._ax, this._ay);
        this._back.setDimensions(this._ax.getLength(), this._ay.getLength());
    }

    public Graph2D(PApplet pApplet, int n, int n2, boolean bl) {
        super(pApplet);
        this._crossAxesAtZero = bl;
        this._xLength = n;
        this._yLength = n2;
        this._border = new GWColour(0, 0, 0);
        this._ax = new Axis2D(pApplet, n);
        this._ax.setTickLabelAlignment(Axis2D.Alignment.CENTER);
        this._ax.setAxesDirection(new PVector(1.0f, 0.0f));
        this._ax.setLabelDirection(new PVector(0.0f, 1.0f));
        this._ax.setAxisLabel("X-Axis");
        this._ay = new Axis2D(pApplet, n2);
        this._ay.setTickLabelAlignment(Axis2D.Alignment.RIGHT);
        this._ay.setAxesDirection(new PVector(0.0f, -1.0f));
        this._ay.setLabelDirection(new PVector(-1.0f, 0.0f));
        this._ay.setLabelRotation(-1.5707964f);
        this._ay.setOffsetLabelByTickLength(true);
        this._ay.setAxisLabel("Y-Axis");
        if (this._crossAxesAtZero) {
            this._alignAxesToZero();
        }
        this._traces = new ArrayList();
    }

    protected void _alignAxesToZero() {
        float f = PApplet.constrain((int)this._ax.valueToPosition(0.0f), (int)0, (int)this._ax.getLength());
        float f2 = PApplet.constrain((int)this._ay.valueToPosition(0.0f), (int)0, (int)this._ay.getLength());
        this._ax.position.y = -f2;
        this._ay.position.x = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addTrace(IGraph2DTrace iGraph2DTrace) {
        if (iGraph2DTrace == null) {
            throw new NullPointerException("Trace object can not be null.");
        }
        int n = -1;
        ArrayList<IGraph2DTrace> arrayList = this._traces;
        synchronized (arrayList) {
            iGraph2DTrace.setParent(this._parent);
            iGraph2DTrace.setGraph(this);
            iGraph2DTrace.onAddTrace(this._traces.toArray());
            iGraph2DTrace.generate();
            this._traces.add(iGraph2DTrace);
            n = this._traces.size() - 1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTrace(IGraph2DTrace iGraph2DTrace) {
        ArrayList<IGraph2DTrace> arrayList = this._traces;
        synchronized (arrayList) {
            iGraph2DTrace.onRemoveTrace();
            this._traces.remove(iGraph2DTrace);
        }
    }

    public void generateTrace(int n) {
        IGraph2DTrace iGraph2DTrace = this._traces.get(n);
        iGraph2DTrace.generate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw() {
        if (this._crossAxesAtZero) {
            this._alignAxesToZero();
        }
        this._parent.pushMatrix();
        this._parent.pushStyle();
        this._parent.translate(this.position.x, this.position.y + this._yLength);
        if (this._back != null) {
            this._back.draw();
        }
        if (this._border != null) {
            this._parent.stroke(this._border.toInt());
            this._parent.noFill();
            this._parent.rect(0.0f, 0.0f, this._xLength, -this._yLength);
        }
        ArrayList<IGraph2DTrace> arrayList = this._traces;
        synchronized (arrayList) {
            for (IGraph2DTrace iGraph2DTrace : this._traces) {
                iGraph2DTrace.draw();
            }
        }
        this._ax.draw();
        this._ay.draw();
        this._parent.popStyle();
        this._parent.popMatrix();
        this._parent.flush();
    }
}

