/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.graph2D;

import java.util.ArrayList;
import org.gwoptics.ValueType;
import org.gwoptics.graphics.GWColour;
import org.gwoptics.graphics.Renderable;
import org.gwoptics.graphics.graph2D.LabelPos;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PFont;
import processing.core.PVector;

public class Axis2D
extends Renderable
implements PConstants {
    private PVector _unitVec;
    protected PVector length;
    private int _length;
    private float _minShow;
    private float _maxShow;
    protected float _axisLineWidth;
    protected float _axisTickLineWidth;
    protected String _tickFontName;
    protected String _labelFontName;
    protected PFont _fontTick;
    protected PFont _fontLabel;
    protected String _label;
    protected PVector _labelDirection;
    protected float _majorTickSpacing;
    protected int _minorTicks;
    protected int _majorTickSize;
    protected int _minorTickSize;
    protected int _axisTickLblSize;
    protected int _axisTickLblLogOffset;
    protected int _axisTickLblOffset;
    protected int _axisLblSize;
    protected float _axisTickLblRotation = 0.0f;
    protected Alignment _axisTickLblAlign;
    protected float _axisLblRotation = 0.0f;
    protected float _axisLblOffset;
    protected LabelPos _axisLblPos;
    protected GWColour _axisColour = new GWColour(0, 0, 0);
    protected GWColour _fontColour = new GWColour(0, 0, 0);
    protected boolean _drawTicks = true;
    protected boolean _drawTickLabels = true;
    protected boolean _drawName = true;
    protected ValueType _tickLblType = ValueType.DECIMAL;
    protected int _accuracy = 1;
    private float _posConv;
    protected float _longestLabel = 0.0f;
    protected ArrayList<Integer> _majorTickPositions;
    protected ArrayList<Double> _majorTickLabels;
    protected ArrayList<Integer> _minorTickPositions;
    protected boolean _generateTicks;
    protected boolean _offsetByLabelWidth;
    protected boolean _isLogarithmic;
    protected float _logMax;
    protected float _logMin;
    protected static final int MIN_TICK_SPACING = 3;

    public void setAxisColour(int n, int n2, int n3) {
        this.setAxisColour(new GWColour(n, n2, n3));
    }

    public void setAxisColour(GWColour gWColour) {
        if (gWColour == null) {
            throw new NullPointerException("Colour argument cannot be null");
        }
        this._axisColour = gWColour;
    }

    public void setLabelFont(String string, int n, boolean bl) {
        this._axisLblSize = n;
        this._labelFontName = string;
        this._fontLabel = this._parent.createFont(this._labelFontName, (float)this._axisLblSize, bl);
    }

    public void setTickFont(String string, int n, boolean bl) {
        this._axisTickLblSize = n;
        this._tickFontName = string;
        this._fontTick = this._parent.createFont(this._tickFontName, (float)this._axisTickLblSize, bl);
    }

    public void setFontColour(int n, int n2, int n3) {
        this.setFontColour(new GWColour(n, n2, n3));
    }

    public void setFontColour(GWColour gWColour) {
        if (gWColour == null) {
            throw new NullPointerException("Colour argument cannot be null");
        }
        this._fontColour = gWColour;
    }

    public void setDrawTicks(boolean bl) {
        this._drawTicks = bl;
    }

    public void setDrawTickLabels(boolean bl) {
        this._drawTickLabels = bl;
    }

    public void setDrawAxisLabel(boolean bl) {
        this._drawName = bl;
    }

    public void setAxisLabel(String string) {
        this._label = string;
    }

    public void setAxisLabelPos(LabelPos labelPos) {
        this._axisLblPos = labelPos;
    }

    public void setLabelOffset(float f) {
        this._axisLblOffset = f;
    }

    public void setOffsetLabelByTickLength(boolean bl) {
        this._offsetByLabelWidth = bl;
    }

    public void setTickLabelOffset(int n) {
        this._axisTickLblOffset = n;
    }

    public void setTickLabelAlignment(Alignment alignment) {
        this._axisTickLblAlign = alignment;
    }

    public void setTickLabelRotation(float f) {
        this._axisTickLblRotation = f;
    }

    public void setLabelRotation(float f) {
        this._axisLblRotation = f;
    }

    public void setLabelDirection(PVector pVector) {
        pVector.normalize();
        this._labelDirection = pVector;
    }

    public void setAxesDirection(PVector pVector) {
        pVector.normalize();
        this._unitVec = pVector;
    }

    public void setTickSpacing(float f) {
        this._majorTickSpacing = f;
        this._generateTicks = true;
    }

    public void setMinorTicks(int n) {
        this._minorTicks = n;
        this._generateTicks = true;
    }

    public void setTickLabelType(ValueType valueType) {
        this._tickLblType = valueType;
    }

    public void setTickLabelAccuracy(int n) {
        this._accuracy = n;
    }

    public void setMajorTickLength(int n) {
        this._majorTickSize = n;
    }

    public void setMinorTickLength(int n) {
        this._minorTickSize = n;
    }

    public void setMaxValue(float f) {
        this._maxShow = f;
        if (this._isLogarithmic) {
            this._logMax = (float)Math.log10(this._maxShow);
            this._logMin = (float)Math.log10(this._minShow);
            this._posConv = (float)(this._length - 1) / (this._logMax - this._logMin);
        } else {
            this._posConv = (float)(this._length - 1) / (this._maxShow - this._minShow);
        }
        this._generateTicks = true;
    }

    public void setMinValue(float f) {
        this._minShow = f;
        if (this._isLogarithmic) {
            this._logMax = (float)Math.log10(this._maxShow);
            this._logMin = (float)Math.log10(this._minShow);
            this._posConv = (float)(this._length - 1) / (this._logMax - this._logMin);
        } else {
            this._posConv = (float)(this._length - 1) / (this._maxShow - this._minShow);
        }
        this._generateTicks = true;
    }

    public float getMajorTickSpacing() {
        return this._majorTickSpacing;
    }

    public float getMaxValue() {
        return this._maxShow;
    }

    public float getMinValue() {
        return this._minShow;
    }

    public int getLength() {
        return this._length;
    }

    public Integer[] getMajorTickPositions() {
        if (this._majorTickPositions != null) {
            Integer[] integerArray = new Integer[this._majorTickPositions.size()];
            integerArray = this._majorTickPositions.toArray(integerArray);
            return integerArray;
        }
        return null;
    }

    public Integer[] getMinorTickPositions() {
        if (this._minorTickPositions != null) {
            Integer[] integerArray = new Integer[this._minorTickPositions.size()];
            integerArray = this._minorTickPositions.toArray(integerArray);
            return integerArray;
        }
        return null;
    }

    public void setLogarithmicAxis(boolean bl) {
        this._isLogarithmic = bl;
        if (this._maxShow == 0.0f || this._minShow == 0.0f) {
            throw new RuntimeException("Axis limits cannot be 0");
        }
        this.setMaxValue(this._maxShow);
        this.setMinValue(this._minShow);
    }

    public Axis2D(PApplet pApplet, int n) {
        super(pApplet);
        this._unitVec = new PVector(1.0f, 0.0f);
        this._labelDirection = new PVector(0.0f, 1.0f);
        this._length = n;
        this._minShow = 0.0f;
        this._maxShow = 1.0f;
        this._majorTickSpacing = 0.5f;
        this._minorTicks = 2;
        this._majorTickSize = 6;
        this._minorTickSize = 3;
        this._axisTickLblSize = 12;
        this._axisLblSize = 12;
        this._axisLblOffset = 4.0f;
        this._axisLblPos = LabelPos.MIDDLE;
        this._axisLineWidth = 2.0f;
        this._axisTickLineWidth = 2.0f;
        this._axisTickLblAlign = Alignment.CENTER;
        this._axisTickLblOffset = 6;
        this._generateTicks = true;
        this._isLogarithmic = false;
        this._labelFontName = "Arial";
        this._tickFontName = "Arial";
        this._posConv = (float)this._length / (this._maxShow - this._minShow);
        this._offsetByLabelWidth = false;
        pApplet.registerMethod("pre", (Object)this);
        this.setLabelFont(this._labelFontName, this._axisLblSize, true);
        this.setTickFont(this._tickFontName, this._axisTickLblSize, true);
    }

    public void pre() {
        if (this._generateTicks) {
            this._generateTicks();
            this._generateTicks = false;
        }
    }

    @Override
    public void draw() {
        this._parent.pushMatrix();
        this._parent.pushStyle();
        this._parent.translate(this.position.x, this.position.y);
        this.length = PVector.mult((PVector)this._unitVec, (float)this._length);
        this._drawAxisLine();
        if (this._drawTicks || this._drawTickLabels) {
            this._drawTicksAndLabels();
        }
        if (this._drawName) {
            this._drawAxisLabel();
        }
        this._parent.popStyle();
        this._parent.popMatrix();
    }

    public int valueToPosition(float f) {
        if (this._isLogarithmic) {
            return (int)Math.round((Math.log10(f) - (double)this._logMin) * (double)this._posConv);
        }
        return Math.round((f - this._minShow) * this._posConv);
    }

    public int valueToPosition(double d) {
        if (this._isLogarithmic) {
            return (int)Math.round((Math.log10(d) - (double)this._logMin) * (double)this._posConv);
        }
        return (int)Math.round((d - (double)this._minShow) * (double)this._posConv);
    }

    public float positionToValue(int n) {
        if (this._isLogarithmic) {
            return (float)Math.pow(10.0, this._logMin + (float)n / this._posConv);
        }
        return this._minShow + (float)n / this._posConv;
    }

    protected void _drawAxisLine() {
        this._parent.pushStyle();
        this._parent.strokeCap(4);
        this._parent.stroke(this._axisColour.toInt());
        this._parent.strokeWeight(this._axisLineWidth);
        this._parent.line(0.0f, 0.0f, this.length.x, this.length.y);
        this._parent.popStyle();
    }

    protected void _generateTicks() {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        this._majorTickLabels = new ArrayList();
        this._majorTickPositions = new ArrayList();
        this._minorTickPositions = new ArrayList();
        if (this._isLogarithmic) {
            d6 = Math.log10(this._minShow) / (double)this._majorTickSpacing;
            d5 = Math.ceil(d6) * (double)this._majorTickSpacing - Math.log10(this._minShow);
            d4 = Math.log10(this._minShow) + d5;
            d3 = this._majorTickSpacing / (float)(this._minorTicks + 1);
            d2 = d4;
            d = Math.log10(this._maxShow);
        } else {
            d6 = this._minShow / this._majorTickSpacing;
            d5 = Math.ceil(d6) * (double)this._majorTickSpacing - (double)this._minShow;
            d4 = (double)this._minShow + d5;
            d3 = this._majorTickSpacing / (float)(this._minorTicks + 1);
            d2 = d4;
            d = this._maxShow;
        }
        d2 -= d3;
        while (d2 >= (double)this._minShow) {
            if (this._isLogarithmic) {
                this._minorTickPositions.add(this.valueToPosition(Math.pow(10.0, d2)));
            } else {
                this._minorTickPositions.add(this.valueToPosition(d2));
            }
            d2 -= d3;
        }
        while (d4 <= d) {
            if (this._isLogarithmic) {
                this._majorTickPositions.add(this.valueToPosition(Math.pow(10.0, d4)));
                this._majorTickLabels.add(Math.pow(10.0, d4));
            } else {
                this._majorTickPositions.add(this.valueToPosition(d4));
                this._majorTickLabels.add(d4);
            }
            for (d2 = d4 + d3; d2 <= d && d2 < d4 + (double)this._majorTickSpacing; d2 += d3) {
                if (this._isLogarithmic) {
                    this._minorTickPositions.add(this.valueToPosition(Math.pow(10.0, d2)));
                    continue;
                }
                this._minorTickPositions.add(this.valueToPosition(d2));
            }
            d4 += (double)this._majorTickSpacing;
        }
    }

    protected void _drawTicksAndLabels() {
        PVector pVector = new PVector(0.0f, 0.0f);
        PVector pVector2 = new PVector(0.0f, 0.0f);
        PVector pVector3 = new PVector(0.0f, 0.0f);
        PVector pVector4 = new PVector(0.0f, 0.0f);
        PVector pVector5 = new PVector(0.0f, 0.0f);
        String string = "";
        this._parent.pushStyle();
        this._parent.strokeCap(4);
        this._parent.strokeWeight(this._axisTickLineWidth);
        this._parent.textFont(this._fontTick);
        this._parent.textAlign(this._axisTickLblAlign.getValue());
        this._parent.stroke(this._axisColour.toInt());
        if (this._axisTickLblAlign == null) {
            this._parent.textAlign(3);
        } else {
            this._parent.textAlign(this._axisTickLblAlign.getValue());
        }
        for (int i = 0; i < this._majorTickPositions.size(); ++i) {
            int n = this._majorTickPositions.get(i);
            double d = this._majorTickLabels.get(i);
            pVector2 = PVector.mult((PVector)this._unitVec, (float)n);
            pVector3 = PVector.add((PVector)pVector2, (PVector)PVector.mult((PVector)this._labelDirection, (float)(-this._majorTickSize)));
            if (this._drawTickLabels) {
                Integer n2 = (int)Math.log10(d);
                switch (this._tickLblType) {
                    case DECIMAL: {
                        int n3;
                        if (this._isLogarithmic) {
                            n3 = this._accuracy - n2;
                            if (n3 < 0) {
                                n3 = 0;
                            }
                        } else {
                            n3 = this._accuracy;
                        }
                        string = String.format(" %." + n3 + "f", d);
                        break;
                    }
                    case EXPONENT: {
                        if (this._isLogarithmic) {
                            double d2 = d / Math.pow(10.0, n2.intValue());
                            if (d2 == 1.0) {
                                string = "10";
                                break;
                            }
                            string = String.format(" %." + this._accuracy + "f", d2) + "x10";
                            break;
                        }
                        string = String.format(" %." + this._accuracy + "E", d);
                        break;
                    }
                    case INTEGER: {
                        string = String.format(" %d", Math.round(d));
                    }
                }
                pVector = this._isLogarithmic && this._axisTickLblAlign.getValue() != 3 ? PVector.add((PVector)pVector2, (PVector)PVector.mult((PVector)this._labelDirection, (float)((float)(this._axisTickLblOffset + Math.abs(this._majorTickSize)) + this._parent.textWidth(n2.toString())))) : PVector.add((PVector)pVector2, (PVector)PVector.mult((PVector)this._labelDirection, (float)(this._axisTickLblOffset + Math.abs(this._majorTickSize))));
                float f = 0.0f;
                f = this._isLogarithmic ? this._parent.textWidth(string) + this._parent.textWidth(n2.toString()) : this._parent.textWidth(string);
                if (f > this._longestLabel) {
                    this._longestLabel = f + 5.0f;
                }
                this._parent.pushMatrix();
                this._parent.translate(pVector.x, pVector.y);
                this._parent.rotate(this._axisTickLblRotation);
                this._parent.fill(this._fontColour.toInt());
                if (this._isLogarithmic && this._tickLblType == ValueType.EXPONENT) {
                    float f2 = 0.0f;
                    this._parent.text(string, 0.0f, 0.4f * (float)this._axisTickLblSize, 0.0f);
                    switch (this._axisTickLblAlign) {
                        case CENTER: {
                            this._parent.textAlign(37);
                            f2 = this._parent.textWidth(string) / 2.0f;
                            break;
                        }
                        case LEFT: {
                            this._parent.textAlign(37);
                            f2 = this._parent.textWidth(string);
                            break;
                        }
                        case RIGHT: {
                            this._parent.textAlign(37);
                            f2 = 0.0f;
                        }
                    }
                    this._parent.text(n2.toString(), f2, -0.2f * (float)this._axisTickLblSize, 0.0f);
                } else {
                    this._parent.text(string, 0.0f, 0.4f * (float)this._axisTickLblSize, 0.0f);
                }
                this._parent.popMatrix();
            }
            if (!this._drawTicks) continue;
            this._parent.line(pVector2.x, pVector2.y, pVector3.x, pVector3.y);
        }
        if (this._drawTicks) {
            for (Integer n : this._minorTickPositions) {
                pVector4 = PVector.mult((PVector)this._unitVec, (float)n.intValue());
                pVector5 = PVector.add((PVector)pVector4, (PVector)PVector.mult((PVector)this._labelDirection, (float)(-this._minorTickSize)));
                this._parent.line(pVector4.x, pVector4.y, pVector5.x, pVector5.y);
            }
        }
        this._parent.popStyle();
    }

    protected void _drawAxisLabel() {
        this._parent.fill(this._fontColour.toInt());
        this._parent.textAlign(3);
        this._parent.textFont(this._fontLabel);
        PVector pVector = new PVector(0.0f, 0.0f, 0.0f);
        switch (this._axisLblPos) {
            case MIDDLE: {
                pVector = PVector.div((PVector)this.length, (float)2.0f);
                break;
            }
            case START: {
                pVector = new PVector(0.0f, 0.0f, 0.0f);
                break;
            }
            case END: {
                pVector = this.length;
                break;
            }
            case OUTSIDE: {
                pVector = PVector.mult((PVector)this.length, (float)1.1f);
            }
        }
        if (this._offsetByLabelWidth) {
            pVector.add(PVector.mult((PVector)this._labelDirection, (float)(this._longestLabel + this._axisLblOffset + (float)this._axisTickLblOffset + (float)Math.abs(this._majorTickSize))));
        } else {
            pVector.add(PVector.mult((PVector)this._labelDirection, (float)((float)this._axisLblSize + this._axisLblOffset + (float)this._axisTickLblOffset + (float)Math.abs(this._majorTickSize))));
        }
        this._parent.pushMatrix();
        this._parent.translate(pVector.x, pVector.y);
        this._parent.rotate(this._axisLblRotation);
        this._parent.text(String.valueOf(this._label), 0.0f, 0.25f * (float)this._fontLabel.getSize(), 0.0f);
        this._parent.popMatrix();
    }

    public static enum Alignment {
        LEFT(37),
        CENTER(3),
        RIGHT(39);

        private int value;

        private Alignment(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }
}

