/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.colourmap;

import java.util.ArrayList;
import java.util.Arrays;
import org.gwoptics.graphics.GWColour;
import org.gwoptics.graphics.colourmap.ColourmapNode;
import org.gwoptics.graphics.colourmap.IColourmap;
import org.gwoptics.graphics.colourmap.MapNeedsGeneratingException;

public class RGBColourmap
implements IColourmap {
    private GWColour[] _cColourmapLookup;
    private int[] _iColourmapLookup;
    private ArrayList<ColourmapNode> _nodes;
    private float _dLoc;
    private boolean _needsGenerating;
    private boolean _isCentreAtZero;

    @Override
    public boolean isCentreAtZero() {
        return this._isCentreAtZero;
    }

    public void setCentreAtZero(boolean bl) {
        this._isCentreAtZero = bl;
    }

    public RGBColourmap() {
        this._cColourmapLookup = new GWColour[100];
        this._nodes = new ArrayList();
        this._dLoc = 0.015873017f;
        this._iColourmapLookup = new int[64];
        this._needsGenerating = true;
    }

    public RGBColourmap(int n) {
        this._cColourmapLookup = new GWColour[n];
        this._nodes = new ArrayList();
        this._dLoc = 1.0f / (float)(n - 1);
        this._iColourmapLookup = new int[n];
        this._needsGenerating = true;
    }

    @Override
    public boolean isGenerated() {
        return !this._needsGenerating;
    }

    public void addNode(ColourmapNode colourmapNode) {
        ColourmapNode colourmapNode2 = new ColourmapNode();
        colourmapNode2.location = colourmapNode.location < 0.0f ? 0.0f : (colourmapNode.location > 1.0f ? 1.0f : colourmapNode.location);
        colourmapNode2.colour.A = colourmapNode.colour.A < 0.0f ? 0.0f : (colourmapNode.colour.A > 1.0f ? 1.0f : colourmapNode.colour.A);
        colourmapNode2.colour.R = colourmapNode.colour.R < 0.0f ? 0.0f : (colourmapNode.colour.R > 1.0f ? 1.0f : colourmapNode.colour.R);
        colourmapNode2.colour.G = colourmapNode.colour.G < 0.0f ? 0.0f : (colourmapNode.colour.G > 1.0f ? 1.0f : colourmapNode.colour.G);
        colourmapNode2.colour.B = colourmapNode.colour.B < 0.0f ? 0.0f : (colourmapNode.colour.B > 1.0f ? 1.0f : colourmapNode.colour.B);
        this._nodes.add(colourmapNode2);
        this._needsGenerating = true;
    }

    @Override
    public void generateColourmap() {
        Object[] objectArray = this._nodes.toArray(new ColourmapNode[this._nodes.size()]);
        if (objectArray.length > 1) {
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length - 1; ++i) {
                int n;
                Object object = objectArray[i];
                Object object2 = objectArray[i + 1];
                int n2 = Math.round(((ColourmapNode)object).location / this._dLoc);
                if (n2 == (n = Math.round(((ColourmapNode)object2).location / this._dLoc))) continue;
                if (i == 0 ? ((ColourmapNode)object).location > 0.0f : i != objectArray.length - 1 || ((ColourmapNode)object).location < 1.0f) {
                    // empty if block
                }
                float f = n - n2;
                float f2 = (((ColourmapNode)object2).colour.A - ((ColourmapNode)object).colour.A) / f;
                float f3 = (((ColourmapNode)object2).colour.R - ((ColourmapNode)object).colour.R) / f;
                float f4 = (((ColourmapNode)object2).colour.G - ((ColourmapNode)object).colour.G) / f;
                float f5 = (((ColourmapNode)object2).colour.B - ((ColourmapNode)object).colour.B) / f;
                for (int j = 0; j < n - n2 + 1; ++j) {
                    this._cColourmapLookup[j + n2] = new GWColour(((ColourmapNode)object).colour.A + (float)j * f2, ((ColourmapNode)object).colour.R + (float)j * f3, ((ColourmapNode)object).colour.G + (float)j * f4, ((ColourmapNode)object).colour.B + (float)j * f5);
                    this._iColourmapLookup[j + n2] = GWColour.convertColourToInt(this._cColourmapLookup[j + n2]);
                }
            }
        } else if (objectArray.length == 1) {
            Object object = objectArray[0];
            for (int i = 0; i < this._cColourmapLookup.length; ++i) {
                this._cColourmapLookup[i] = new GWColour(((ColourmapNode)object).colour.A, ((ColourmapNode)object).colour.R, ((ColourmapNode)object).colour.G, ((ColourmapNode)object).colour.B);
            }
        } else {
            for (int i = 0; i < this._cColourmapLookup.length; ++i) {
                this._cColourmapLookup[i] = new GWColour(0, 0, 0);
            }
        }
        this._needsGenerating = false;
    }

    @Override
    public GWColour getColourAtLocation(float f) {
        if (this._needsGenerating) {
            throw new MapNeedsGeneratingException();
        }
        float f2 = f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
        return this._cColourmapLookup[Math.round(f2 / this._dLoc)];
    }

    @Override
    public int getIntAtLocation(float f) {
        if (this._needsGenerating) {
            throw new MapNeedsGeneratingException();
        }
        float f2 = f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
        return this._iColourmapLookup[Math.round(f2 / this._dLoc)];
    }

    public ColourmapNode getNode(int n) {
        if (this._nodes.size() <= n) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this._nodes.get(n);
    }

    public void setNode(int n, ColourmapNode colourmapNode) {
        if (this._nodes.size() <= n) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this._nodes.set(n, colourmapNode);
    }

    public void removeNode(int n) {
        if (this._nodes.size() <= n) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this._nodes.remove(n);
    }

    public int getNodeCount() {
        return this._nodes.size();
    }
}

