/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.colourmap;

import org.gwoptics.graphics.GWColour;
import org.gwoptics.graphics.colourmap.IColourmap;
import org.gwoptics.graphics.colourmap.IColourmapEquation;
import org.gwoptics.graphics.colourmap.MapNeedsGeneratingException;

public class EquationColourmap
implements IColourmap {
    private GWColour[] _cColourmapLookup;
    private int[] _iColourmapLookup;
    private boolean _needsGenerating;
    private IColourmapEquation _eq;
    private float _dLoc;
    private boolean _isCentreAtZero;

    @Override
    public boolean isCentreAtZero() {
        return this._isCentreAtZero;
    }

    public void setCentreAtZero(boolean bl) {
        this._isCentreAtZero = bl;
    }

    public EquationColourmap(IColourmapEquation iColourmapEquation) {
        if (iColourmapEquation == null) {
            throw new NullPointerException("Object requires a non null IColourmapEquation.");
        }
        this._cColourmapLookup = new GWColour[64];
        this._iColourmapLookup = new int[64];
        this._dLoc = 0.015873017f;
    }

    public EquationColourmap(int n, IColourmapEquation iColourmapEquation) {
        if (iColourmapEquation == null) {
            throw new NullPointerException("Object requires a non null IColourmapEquation.");
        }
        if (n < 1) {
            n = 1;
        }
        this._eq = iColourmapEquation;
        this._cColourmapLookup = new GWColour[n];
        this._iColourmapLookup = new int[n];
        this._dLoc = 1.0f / (float)(n - 1);
    }

    @Override
    public boolean isGenerated() {
        return !this._needsGenerating;
    }

    @Override
    public void generateColourmap() {
        for (int i = 0; i < this._cColourmapLookup.length; ++i) {
            GWColour gWColour;
            this._cColourmapLookup[i] = gWColour = this._eq.colourmapEquation(this._dLoc * (float)i);
            this._iColourmapLookup[i] = gWColour.toInt();
        }
        this._needsGenerating = false;
    }

    @Override
    public GWColour getColourAtLocation(float f) {
        if (this._needsGenerating) {
            throw new MapNeedsGeneratingException();
        }
        float f2 = f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
        return this._cColourmapLookup[Math.round(f2 / this._dLoc)];
    }

    @Override
    public int getIntAtLocation(float f) {
        if (this._needsGenerating) {
            throw new MapNeedsGeneratingException();
        }
        float f2 = f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
        return this._iColourmapLookup[Math.round(f2 / this._dLoc)];
    }
}

