/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics.camera;

import org.gwoptics.mathutils.VectorUtils;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PVector;
import processing.event.MouseEvent;

public final class Camera3D
implements PConstants {
    private PApplet _parent;
    private PVector _lookat;
    private PVector _up;
    private PVector _position;
    private float _nearLimit = 200.0f;
    private float _farLimit = 2000.0f;
    private float prevX;
    private float prevY;
    private PVector A = new PVector();
    private boolean _orthoView;
    private static Camera3D _cam;

    public void setLookat(PVector pVector) {
        this._lookat = pVector;
    }

    public void setPosition(PVector pVector) {
        this._position = pVector;
    }

    public void setNearLimit(float f) {
        this._nearLimit = f;
    }

    public void setFarLimit(float f) {
        this._farLimit = f;
    }

    public void setUpVector(PVector pVector) {
        this._up = pVector;
    }

    public float getNearLimit() {
        return this._nearLimit;
    }

    public float getFarLimit() {
        return this._farLimit;
    }

    public static PVector getPosition() {
        if (_cam == null) {
            return null;
        }
        return Camera3D._cam._position.get();
    }

    public static PVector getLookat() {
        if (_cam == null) {
            return null;
        }
        return Camera3D._cam._lookat.get();
    }

    public static PVector getUpVector() {
        if (_cam == null) {
            return null;
        }
        return Camera3D._cam._up.get();
    }

    public static PVector getEyeVector() {
        PVector pVector = PVector.sub((PVector)Camera3D._cam._lookat, (PVector)Camera3D._cam._position);
        pVector.normalize();
        return pVector;
    }

    public static PVector getRightVector() {
        PVector pVector = Camera3D.getEyeVector();
        PVector pVector2 = Camera3D.getUpVector();
        PVector pVector3 = pVector.cross(pVector2);
        pVector3.normalize();
        return pVector3;
    }

    public static PVector getRelativePosition() {
        return PVector.mult((PVector)PVector.sub((PVector)Camera3D._cam._lookat, (PVector)Camera3D._cam._position), (float)-1.0f);
    }

    public Camera3D(PApplet pApplet) {
        if (pApplet == null) {
            throw new NullPointerException("Can not except null parent.");
        }
        if (_cam != null) {
            throw new RuntimeException("A camera3D object has already been created.");
        }
        _cam = this;
        this._parent = pApplet;
        this._position = new PVector(100.0f, 100.0f, 100.0f);
        this._lookat = new PVector(0.0f, 0.0f, 0.0f);
        this._up = new PVector(0.0f, -1.0f, 0.0f);
        this._orthoView = false;
        this._parent.camera(this._position.x, this._position.y, this._position.z, this._lookat.x, this._lookat.y, this._lookat.z, this._up.x, this._up.y, this._up.z);
        pApplet.registerMethod("draw", (Object)this);
        pApplet.registerMethod("dispose", (Object)this);
        pApplet.registerMethod("mouseEvent", (Object)this);
    }

    public Camera3D(PApplet pApplet, boolean bl) {
        this(pApplet);
        if (!bl) {
            pApplet.unregisterMethod("mouseEvent", (Object)this);
        }
    }

    public void dispose() {
        PApplet.println((String)"\nCamera disposed\n");
        _cam = null;
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getAction()) {
            case 4: {
                PVector pVector;
                float f = this.prevX - (float)mouseEvent.getX();
                float f2 = this.prevY - (float)mouseEvent.getY();
                if (this._parent.mouseButton == 37 && !mouseEvent.isControlDown()) {
                    pVector = VectorUtils.rotateArbitaryAxis(Camera3D.getRelativePosition(), new PVector(0.0f, 1.0f, 0.0f), -f * (float)Math.PI / 100.0f);
                    this._position = PVector.add((PVector)pVector, (PVector)this._lookat);
                    float f3 = f2 * (float)Math.PI / 100.0f;
                    PVector pVector2 = Camera3D.getRelativePosition();
                    this.A = new PVector(0.0f, 0.0f, 1.0f);
                    float f4 = (float)Math.atan2(pVector2.x, pVector2.z) + 1.5707964f;
                    this.A = VectorUtils.rotateArbitaryAxis(this.A, new PVector(0.0f, 1.0f, 0.0f), f4);
                    PVector pVector3 = VectorUtils.rotateArbitaryAxis(pVector2, this.A, f3);
                    if (Math.signum(pVector2.x) == Math.signum(pVector3.x) && Math.signum(pVector2.z) == Math.signum(pVector3.z)) {
                        this._position = PVector.add((PVector)pVector3, (PVector)this._lookat);
                    }
                }
                if (this._parent.mouseButton == 39 || this._parent.mouseButton == 37 && mouseEvent.isControlDown()) {
                    pVector = PVector.add((PVector)this._position, (PVector)PVector.mult((PVector)Camera3D.getEyeVector(), (float)(f2 * 20.0f)));
                    PVector pVector4 = PVector.sub((PVector)pVector, (PVector)this._lookat);
                    if (pVector4.mag() < this._nearLimit || pVector4.mag() > this._farLimit) {
                        pVector = this._position;
                    }
                    this._position = pVector;
                }
                this.prevX = mouseEvent.getX();
                this.prevY = mouseEvent.getY();
                break;
            }
            case 5: {
                this.prevX = mouseEvent.getX();
                this.prevY = mouseEvent.getY();
            }
        }
    }

    public void setOrthographicView() {
        this._orthoView = true;
    }

    public void setPerspectiveView() {
        this._orthoView = false;
        float f = 1.0471976f;
        float f2 = (float)((double)this._parent.height / 2.0 / Math.tan((double)f / 2.0));
        this._parent.perspective(f, (float)this._parent.width / (float)this._parent.height, (float)((double)f2 / 100.0), 20000.0f);
    }

    public void draw() {
        if (this._orthoView) {
            PVector pVector = new PVector(this._position.x, this._position.y, this._position.z);
            float f = 0.0012820513f * PVector.sub((PVector)pVector, (PVector)this._lookat).mag();
            this._parent.ortho((float)(-this._parent.width) * f, (float)this._parent.width * f, (float)(-this._parent.height) * f, (float)this._parent.height * f, -10000.0f, 10000.0f);
            this._parent.camera(this._position.x, this._position.y, this._position.z, this._lookat.x, this._lookat.y, this._lookat.z, this._up.x, this._up.y, this._up.z);
        } else {
            this._parent.camera(this._position.x, this._position.y, this._position.z, this._lookat.x, this._lookat.y, this._lookat.z, this._up.x, this._up.y, this._up.z);
        }
    }
}

