/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.graphics;

import processing.core.PApplet;

public final class GWColour {
    public float A;
    public float R;
    public float G;
    public float B;

    public GWColour() {
        this.A = 1.0f;
        this.R = 0.0f;
        this.G = 0.0f;
        this.B = 0.0f;
    }

    public GWColour(int n) {
        this.B = (float)(n & 0xFF) / 255.0f;
        this.G = (float)(n >> 8 & 0xFF) / 255.0f;
        this.R = (float)(n >> 16 & 0xFF) / 255.0f;
        this.A = (float)(n >> 24 & 0xFF) / 255.0f;
    }

    public GWColour(float f, float f2, float f3) {
        this.A = 1.0f;
        this.R = PApplet.constrain((float)f, (float)0.0f, (float)1.0f);
        this.G = PApplet.constrain((float)f2, (float)0.0f, (float)1.0f);
        this.B = PApplet.constrain((float)f3, (float)0.0f, (float)1.0f);
    }

    public GWColour(float f, float f2, float f3, float f4) {
        this.A = PApplet.constrain((float)f, (float)0.0f, (float)1.0f);
        this.R = PApplet.constrain((float)f2, (float)0.0f, (float)1.0f);
        this.G = PApplet.constrain((float)f3, (float)0.0f, (float)1.0f);
        this.B = PApplet.constrain((float)f4, (float)0.0f, (float)1.0f);
    }

    public GWColour(int n, int n2, int n3) {
        this.A = 1.0f;
        this.R = PApplet.constrain((float)((float)n / 255.0f), (float)0.0f, (float)1.0f);
        this.G = PApplet.constrain((float)((float)n2 / 255.0f), (float)0.0f, (float)1.0f);
        this.B = PApplet.constrain((float)((float)n3 / 255.0f), (float)0.0f, (float)1.0f);
    }

    public GWColour(int n, int n2, int n3, int n4) {
        this.A = PApplet.constrain((float)((float)n / 255.0f), (float)0.0f, (float)1.0f);
        this.R = PApplet.constrain((float)((float)n2 / 255.0f), (float)0.0f, (float)1.0f);
        this.G = PApplet.constrain((float)((float)n3 / 255.0f), (float)0.0f, (float)1.0f);
        this.B = PApplet.constrain((float)((float)n4 / 255.0f), (float)0.0f, (float)1.0f);
    }

    public String toString() {
        return "(" + this.A + "," + this.R + "," + this.G + "," + this.B + ")";
    }

    public static int convertRGBToInt(byte by, byte by2, byte by3) {
        return 0xFF000000 | by << 16 | by2 << 8 | by3;
    }

    public static int convertARGBToInt(byte by, byte by2, byte by3, byte by4) {
        return by << 24 | by2 << 16 | by3 << 8 | by4;
    }

    public static int convertColourToInt(GWColour gWColour) {
        return (int)(gWColour.A * 255.0f) << 24 | (int)(gWColour.R * 255.0f) << 16 | (int)(gWColour.G * 255.0f) << 8 | (int)(gWColour.B * 255.0f);
    }

    public static GWColour convertIntToColour(int n) {
        GWColour gWColour = new GWColour();
        gWColour.B = (float)(n & 0xFF) / 255.0f;
        gWColour.G = (float)(n >> 8 & 0xFF) / 255.0f;
        gWColour.R = (float)(n >> 16 & 0xFF) / 255.0f;
        gWColour.A = (float)(n >> 24 & 0xFF) / 255.0f;
        return gWColour;
    }

    public static GWColour add(GWColour gWColour, GWColour gWColour2) {
        GWColour gWColour3 = new GWColour(gWColour.A * gWColour.R + gWColour2.A * gWColour2.R, gWColour.A * gWColour.G + gWColour2.A * gWColour2.G, gWColour.A * gWColour.B + gWColour2.A * gWColour2.B);
        gWColour3.A = 1.0f;
        return gWColour3;
    }

    public static GWColour multiply(GWColour gWColour, GWColour gWColour2) {
        GWColour gWColour3 = new GWColour(gWColour.A * gWColour.R * gWColour2.A * gWColour2.R, gWColour.A * gWColour.G * gWColour2.A * gWColour2.G, gWColour.A * gWColour.B * gWColour2.A * gWColour2.B);
        gWColour3.A = 1.0f;
        return gWColour3;
    }

    public static int getAlphaRGB(GWColour gWColour) {
        return (int)(gWColour.R * gWColour.A * 255.0f) << 16 | (int)(gWColour.G * gWColour.A * 255.0f) << 8 | (int)(gWColour.B * gWColour.A * 255.0f);
    }

    public int toInt() {
        return GWColour.convertColourToInt(this);
    }

    public int toAlphaInt() {
        return GWColour.getAlphaRGB(this);
    }
}

