/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics.gaussbeams;

import org.gwoptics.mathutils.Complex;
import org.gwoptics.mathutils.mathUtils;

public class GaussMode {
    double _lambda;
    double _nr;
    public Complex _qx;
    public Complex _qy;

    public GaussMode() {
        this._lambda = 1.064E-6;
        this._nr = 1.0;
        this._qx = GaussMode.make_q(0.001, 0.0, this._lambda, this._nr);
        this._qy = GaussMode.make_q(0.001, 0.0, this._lambda, this._nr);
    }

    public GaussMode(float f, Complex complex, float f2) {
        assert (f > 0.0f);
        assert (complex.imag() > 0.0);
        this._lambda = f;
        this._qx = complex;
        this._qy = complex;
        this._nr = f2;
    }

    public GaussMode(float f, Complex complex, Complex complex2, float f2) {
        assert (f > 0.0f);
        assert (complex.imag() > 0.0);
        assert (complex2.imag() > 0.0);
        this._lambda = f;
        this._qx = complex;
        this._qy = complex2;
        this._nr = f2;
    }

    public GaussMode(float f, float f2, float f3, float f4) {
        assert (f > 0.0f);
        assert (f2 > 0.0f);
        this._lambda = f;
        this._nr = f4;
        this._qy = this._qx = GaussMode.make_q(f2, f3, this._lambda, this._nr);
    }

    public GaussMode(float f, float f2, float f3, float f4, float f5, float f6) {
        assert (f > 0.0f);
        assert (f2 > 0.0f);
        assert (f4 > 0.0f);
        this._lambda = f;
        this._nr = f6;
        this._qx = GaussMode.make_q(f2, f3, this._lambda, this._nr);
        this._qy = GaussMode.make_q(f4, f5, this._lambda, this._nr);
    }

    public double get_lambda() {
        return this._lambda;
    }

    public double get_nr() {
        return this._nr;
    }

    public Complex get_qx() {
        return this._qx;
    }

    public Complex get_qy() {
        return this._qy;
    }

    public double get_w0x() {
        return this.w0_size(this._qx);
    }

    public double get_w0y() {
        return this.w0_size(this._qy);
    }

    public double get_wx() {
        return this.w_size(this._qx);
    }

    public double get_wy() {
        return this.w_size(this._qy);
    }

    public double get_zx() {
        return this._qx.real();
    }

    public double get_zy() {
        return this._qy.real();
    }

    public double get_zrx() {
        return this._qx.imag();
    }

    public double get_zry() {
        return this._qy.imag();
    }

    public double get_ROCx() {
        return GaussMode.ROC(this._qx);
    }

    public double get_ROCy() {
        return GaussMode.ROC(this._qy);
    }

    public double get_Gouyx() {
        return GaussMode.Gouy(this._qx);
    }

    public double get_Gouyy() {
        return GaussMode.Gouy(this._qy);
    }

    public Complex get_q0x() {
        return GaussMode.q0(this._qx);
    }

    public Complex get_q0y() {
        return GaussMode.q0(this._qy);
    }

    public static Complex make_q(double d, double d2, double d3, double d4) {
        Complex complex = new Complex(0.0);
        complex.setReal(d2);
        complex.setImag(d * d * Math.PI / d3 * d4);
        return complex;
    }

    public Double w0_size(Complex complex) {
        return Math.sqrt(complex.imag() / Math.PI) * Math.sqrt(this._lambda / this._nr);
    }

    public static Double w0_size(Complex complex, Double d, Double d2) {
        assert (d2 > 0.0);
        assert (d > 0.0);
        return Math.sqrt(complex.imag() / Math.PI) * Math.sqrt(d / d2);
    }

    public Double w_size(Complex complex) {
        assert (complex.imag() > 0.0);
        return Complex.modulus(complex) / Math.sqrt(Math.PI * complex.imag()) * Math.sqrt(this._lambda / this._nr);
    }

    public static Double w_size(Complex complex, Double d, Double d2) {
        assert (d2 > 0.0);
        assert (d > 0.0);
        assert (complex.imag() > 0.0);
        return Complex.modulus(complex) / Math.sqrt(Math.PI * complex.imag()) * Math.sqrt(d / d2);
    }

    public static Double ROC(Complex complex) {
        return Complex.absSquared(complex) / Complex.real(complex);
    }

    public static Double Gouy(Complex complex) {
        assert (complex.imag() > 0.0);
        return Complex.real(complex) / Complex.imag(complex);
    }

    public static Complex q0(Complex complex) {
        Complex complex2 = complex;
        complex2.setReal(0.0);
        return complex2;
    }

    public static Double zr(Complex complex) {
        return complex.imag();
    }

    public Complex u_nm(int n, int n2, double d, double d2) {
        Complex complex = Complex.multiply(this.u_n(n, this._qx, d), this.u_n(n2, this._qy, d2));
        return complex;
    }

    public double u_nm_amp(int n, int n2, double d, double d2) {
        double d3 = this.u_n_amp(n, this._qx, d) * this.u_n_amp(n2, this._qy, d2);
        return d3;
    }

    public double u_nm_phs(int n, int n2, double d, double d2) {
        double d3 = this.u_n_phs(n, this._qx, d) + this.u_n_phs(n2, this._qy, d2);
        return d3;
    }

    public double u_n_amp(int n, Complex complex, double d) {
        assert (n >= 0);
        assert (complex.imag() > 0.0);
        Double d2 = GaussMode.w_size(complex, this._lambda, this._nr);
        Double d3 = 0.8932438417380023;
        Double d4 = d3 / Math.sqrt(Math.pow(2.0, n) * (double)mathUtils.factorial(n) * d2) * mathUtils.hermite(n, Math.sqrt(2.0) * d / GaussMode.w_size(complex, this._lambda, this._nr));
        d4 = d4 * Math.exp(-1.0 * d * d / (d2 * d2));
        return d4;
    }

    public double u_n_phs(int n, Complex complex, double d) {
        assert (n >= 0);
        assert (complex.imag() > 0.0);
        Double d2 = GaussMode.ROC(complex);
        Double d3 = GaussMode.Gouy(complex);
        Double d4 = Math.PI * 2 / this._lambda * this._nr;
        Double d5 = ((double)n + 0.5) * d3;
        d5 = d5 - d4 * Math.pow(d, 2.0) / (2.0 * d2);
        return d5;
    }

    public Complex u_n(int n, Complex complex, double d) {
        assert (n >= 0);
        assert (complex.imag() > 0.0);
        Double d2 = 0.8932438417380023;
        Double d3 = Math.PI * 2 / this._lambda * this._nr;
        Double d4 = d2 / Math.sqrt(Math.pow(2.0, n) * (double)mathUtils.factorial(n) * GaussMode.w0_size(complex, this._lambda, this._nr)) * mathUtils.hermite(n, Math.sqrt(2.0) * d / GaussMode.w_size(complex, this._lambda, this._nr));
        Complex complex2 = Complex.sqrt(Complex.divide(GaussMode.q0(complex), complex));
        Complex complex3 = Complex.sqrt(Complex.divide(Complex.multiply(GaussMode.q0(complex), Complex.conj(complex)), Complex.multiply(Complex.conj(GaussMode.q0(complex)), complex)));
        Complex complex4 = Complex.multiply(complex2, Complex.pow(complex3, n, 1));
        Complex complex5 = Complex.scale(-1.0 * d3 * d * d / 2.0, Complex.inv(complex));
        d4 = d4 * Math.exp(-1.0 * complex5.imag());
        Complex complex6 = Complex.scaleAndDelay(d4, complex5.real(), complex4);
        return complex6;
    }

    public Complex u_pl_xy(int n, int n2, double d, double d2) {
        Double d3 = Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2, 2.0));
        Double d4 = Math.atan2(d, d2);
        return this.u_pl(n, n2, d3, d4);
    }

    public Complex u_pl(int n, int n2, double d, double d2) {
        int n3 = Math.abs(n2);
        if (n < 0) {
            throw new RuntimeException("LG mode index error (p<0)");
        }
        Complex complex = this._qx;
        Double d3 = Math.PI * 2 / this._lambda * this._nr;
        Double d4 = GaussMode.w_size(complex, this._lambda, this._nr);
        Double d5 = Math.sqrt(2.0) * d / d4;
        Double d6 = GaussMode.Gouy(complex);
        Double d7 = Complex.absSquared(complex);
        Double d8 = -0.5 * d3 * d * d;
        Double d9 = Math.sqrt((double)(2L * mathUtils.factorial(n)) / (Math.PI * (double)mathUtils.factorial(n3 + n))) / d4;
        Double d10 = (double)(2 * n + n3 + 1) * d6;
        Double d11 = Math.exp(d8 * complex.imag() / d7) * Math.pow(d5, n3) * mathUtils.laguerre(n, n3, d5 * d5);
        Double d12 = (double)n2 * d2;
        Double d13 = d8 * complex.real() / d7;
        return Complex.newAbsPhi(d9 * d11, d10 + d13 + d12);
    }

    public double u_pl_amp_xy(int n, int n2, double d, double d2) {
        Double d3 = Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2, 2.0));
        Double d4 = Math.atan2(d, d2);
        return this.u_pl_amp(n, n2, d3, d4);
    }

    public double u_pl_amp(int n, int n2, double d, double d2) {
        int n3 = Math.abs(n2);
        if (n < 0) {
            throw new RuntimeException("LG mode index error (p<0)");
        }
        Complex complex = this._qx;
        Double d3 = Math.PI * 2 / this._lambda * this._nr;
        Double d4 = GaussMode.w_size(complex, this._lambda, this._nr);
        Double d5 = Math.sqrt(2.0) * d / d4;
        Double d6 = Complex.absSquared(complex);
        Double d7 = -0.5 * d3 * d * d;
        Double d8 = Math.sqrt((double)(2L * mathUtils.factorial(n)) / (Math.PI * (double)mathUtils.factorial(n3 + n))) / d4;
        Double d9 = Math.exp(d7 * complex.imag() / d6) * Math.pow(d5, n3) * mathUtils.laguerre(n, n3, d5 * d5);
        return d8 * d9;
    }

    public Complex u_lp_cos_xy(int n, int n2, double d, double d2) {
        Double d3 = Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2, 2.0));
        Double d4 = Math.atan2(d, d2);
        return this.u_pl_cos(n, n2, d3, d4);
    }

    public Complex u_pl_cos(int n, int n2, double d, double d2) {
        int n3 = Math.abs(n2);
        if (n < 0) {
            throw new RuntimeException("LG mode index error (p<0)");
        }
        Complex complex = this._qx;
        Double d3 = Math.PI * 2 / this._lambda * this._nr;
        Double d4 = GaussMode.w_size(complex, this._lambda, this._nr);
        Double d5 = Math.sqrt(2.0) * d / d4;
        Double d6 = GaussMode.Gouy(complex);
        Double d7 = Complex.absSquared(complex);
        Double d8 = -0.5 * d3 * d * d;
        Double d9 = Math.sqrt((double)(2L * mathUtils.factorial(n)) / (Math.PI * (double)mathUtils.factorial(n3 + n))) / d4;
        Double d10 = (double)(2 * n + n3 + 1) * d6;
        Double d11 = Math.exp(d8 * complex.imag() / d7) * Math.pow(d5, n3) * mathUtils.laguerre(n, n3, d5 * d5);
        Double d12 = (double)n2 * d2;
        Double d13 = d8 * complex.real() / d7;
        return Complex.newAbsPhi(d9 * d11 * Math.cos(d12), d10 + d13);
    }

    public double u_pl_cos_amp_xy(int n, int n2, double d, double d2) {
        Double d3 = Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2, 2.0));
        Double d4 = Math.atan2(d, d2);
        return this.u_pl_cos_amp(n, n2, d3, d4);
    }

    public double u_pl_cos_amp(int n, int n2, double d, double d2) {
        int n3 = Math.abs(n2);
        if (n < 0) {
            throw new RuntimeException("LG mode index error (p<0)");
        }
        Complex complex = this._qx;
        Double d3 = Math.PI * 2 / this._lambda * this._nr;
        Double d4 = GaussMode.w_size(complex, this._lambda, this._nr);
        Double d5 = Math.sqrt(2.0) * d / d4;
        Double d6 = Complex.absSquared(complex);
        Double d7 = -0.5 * d3 * d * d;
        Double d8 = Math.sqrt((double)(2L * mathUtils.factorial(n)) / (Math.PI * (double)mathUtils.factorial(n3 + n))) / d4;
        Double d9 = Math.exp(d7 * complex.imag() / d6) * Math.pow(d5, n3) * mathUtils.laguerre(n, n3, d5 * d5);
        Double d10 = (double)n2 * d2;
        return d8 * d9 * Math.cos(d10);
    }
}

