/*
 * Decompiled with CFR 0.152.
 */
package org.gwoptics;

import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.gwoptics.LogoSize;
import org.gwoptics.graphics.GWColour;
import org.gwoptics.graphics.Renderable;
import processing.core.PApplet;
import processing.core.PImage;

public class Logo
extends Renderable {
    private boolean _clickable;
    private PImage _logo;
    private PImage _logoMouseOver;
    private boolean _isMouseOverLogo;
    private PApplet _parent;

    public Logo(PApplet pApplet, float f, float f2, boolean bl) {
        this(pApplet, f, f2, bl, LogoSize.Size35);
    }

    public Logo(PApplet pApplet, float f, float f2, boolean bl, LogoSize logoSize) {
        super(pApplet);
        this.position.x = f;
        this.position.y = f2;
        this._clickable = bl;
        this._parent = pApplet;
        pApplet.registerMethod("mouseEvent", (Object)this);
        this._logo = pApplet.loadImage("gwoptics_org_logo_" + logoSize.getSize() + "px.png");
        this._logoMouseOver = pApplet.loadImage("gwoptics_org_logo_shadow_" + logoSize.getSize() + "px.png");
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        this._isMouseOverLogo = this._isMouseOver();
        if (mouseEvent.getID() == 500 && this._isMouseOverLogo && this._clickable) {
            this._parent.link("http://www.gwoptics.org");
        }
    }

    @Override
    public void draw() {
        if (this._isMouseOverLogo) {
            this._parent.image(this._logoMouseOver, this.position.x, this.position.y);
        } else {
            this._parent.image(this._logo, this.position.x, this.position.y);
        }
    }

    public void clearBackground(int n, GWColour gWColour) {
        this._parent.pushStyle();
        this._parent.noStroke();
        this._parent.fill(gWColour.toInt());
        this._parent.rect((float)((int)this.position.x - n), (float)((int)this.position.y - n), (float)(this._logo.width + 2 * n), (float)(this._logo.height + 2 * n));
        this._parent.popStyle();
    }

    private boolean _isMouseOver() {
        Rectangle rectangle = new Rectangle((int)this.position.x, (int)this.position.y, this._logo.width, this._logo.height);
        return rectangle.contains(this._parent.mouseX, this._parent.mouseY);
    }
}

