/*
 * Decompiled with CFR 0.152.
 */
package procontroll;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;

class Plug {
    private final Method method;
    private final String methodName;
    private final Object object;
    private final Class objectClass;
    private boolean hasParameter = false;

    public Plug(Object i_object, String i_methodName) {
        this.object = i_object;
        this.objectClass = this.object.getClass();
        this.methodName = i_methodName;
        this.method = this.initPlug();
    }

    public Plug(Object i_object, String i_methodName, boolean i_hasParameter) {
        this.object = i_object;
        this.objectClass = this.object.getClass();
        this.methodName = i_methodName;
        this.hasParameter = i_hasParameter;
        this.method = this.initPlug();
    }

    boolean hasParamter() {
        return this.hasParameter;
    }

    private boolean checkParameter(Class[] objectMethodParams) throws Exception {
        if (this.hasParameter) {
            if (objectMethodParams.length == 2 && this.hasParameter) {
                Class paramClass1 = objectMethodParams[0];
                Class paramClass2 = objectMethodParams[1];
                if (paramClass1.getName().equals("float") && paramClass2.getName().equals("float")) {
                    return true;
                }
                throw new RuntimeException("Your plugged method is only allowed to receive float values. Change you method signature from " + this.methodName + "(" + paramClass1.getName() + "," + paramClass2.getName() + ") to:" + this.methodName + "(float x, float y).");
            }
            throw new RuntimeException("To plug a cross button method your method needs to receive two float values. Change you method signature to " + this.methodName + "(float x, float y).");
        }
        if (objectMethodParams.length == 0) {
            return true;
        }
        throw new RuntimeException("To plug a button method your method is not allowed to receive parameters.Change you method signature to " + this.methodName + "( ).");
    }

    private Method initPlug() {
        if (this.methodName != null && this.methodName.length() > 0) {
            Method[] objectMethods = this.objectClass.getDeclaredMethods();
            int i = 0;
            while (i < objectMethods.length) {
                ((AccessibleObject)objectMethods[i]).setAccessible(true);
                if (objectMethods[i].getName().equals(this.methodName)) {
                    Class[] objectMethodParams = objectMethods[i].getParameterTypes();
                    try {
                        this.checkParameter(objectMethodParams);
                        return this.objectClass.getDeclaredMethod(this.methodName, objectMethodParams);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                }
                ++i;
            }
        }
        throw new RuntimeException("Error on plug: >" + this.methodName + "< proControll found no method with that name in the given object.");
    }

    void call(float i_x, float i_y) {
        try {
            this.method.invoke(this.object, new Float(i_x), new Float(i_y));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error on calling plug: " + this.methodName);
        }
    }

    void call() {
        try {
            this.method.invoke(this.object, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error on calling plug: " + this.methodName);
        }
    }
}

