/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Robot;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import procontroll.ControllButton;
import procontroll.ControllDevice;
import procontroll.ControllIO;
import procontroll.ControllSlider;

public class BlackholePong
extends PApplet {
    static final float small_horizon = 1.2f;
    static final float large_horizon = 3.0f;
    static final int bh_width = 60;
    static final float fps = 90.0f;
    static final int maximages = 8;
    static final int fade_T = 25000;
    static final float score_delay = 2500.0f;
    static final int max_rounds = 14;
    static final String VersionString = "1.2 (17.02.2011)";
    PImage[] backgrounds = new PImage[8];
    PImage paused_image;
    PImage paused_background;
    PImage paused_text;
    PImage paused_mask;
    boolean paused;
    float pause_timer;
    PImage start_image;
    PImage credit_image;
    int current_background;
    int fade_level;
    float fade_timer;
    boolean fading = false;
    int lower_post;
    int upper_post;
    boolean loaded;
    int current_round;
    boolean round_init;
    boolean use_robot = true;
    Sound music;
    Credits all_credits;
    boolean[] keys = new boolean[526];
    PImage bg;
    PFont sf;
    PFont sf1;
    PFont sf2;
    PFont sf3;
    int screen_state;
    Blackhole bh1;
    Blackhole bh2;
    int blackhole_offset;
    ArrayList stars;
    Star star;
    boolean star_init;
    float star_timer;
    int star_count;
    float whirl1_speed = 0.01f;
    float whirl2_speed = 0.01f;
    ControllIO controll;
    Player player1;
    Player player2;
    Robot robot;
    float score_timer;
    int image_loading;
    PImage logo0;
    PImage logo1;
    boolean runningOSX = false;
    boolean Osound;
    boolean Omusic;
    int graphics_level = 3;
    Minim minim;

    public void setup() {
        this.size(800, 600, "processing.opengl.PGraphicsOpenGL");
        this.hint(2);
        this.frame.setBackground(new Color(0, 0, 0));
        this.frameRate(90.0f);
        this.noCursor();
        String string = System.getProperty("os.name");
        if (string.indexOf("Mac") != -1) {
            this.runningOSX = true;
        }
        Frame[] frameArray = Frame.getFrames();
        int n = frameArray.length;
        int n2 = 0;
        while (n2 < n) {
            Frame frame = frameArray[n2];
            frame.setTitle("Black Hole Pong");
            ImageIcon imageIcon = new ImageIcon(this.loadBytes("bhp_logo32.gif"));
            frame.setIconImage(imageIcon.getImage());
            ++n2;
        }
        this.minim = new Minim((PApplet)this);
        this.music = new Sound();
        this.all_credits = new Credits();
        this.Osound = true;
        this.Omusic = true;
        this.lower_post = 0;
        this.upper_post = this.height;
        this.sf = this.createFont("Arial", (float)(128 * this.width) / 800.0f);
        this.sf1 = this.createFont("Arial", (float)(80 * this.width) / 800.0f);
        this.sf2 = this.createFont("Arial", (float)(24 * this.width) / 800.0f);
        this.sf3 = this.createFont("Arial", (float)(48 * this.width) / 800.0f);
        if (this.use_robot) {
            try {
                this.robot = new Robot();
            }
            catch (AWTException aWTException) {}
        }
        this.bg = this.loadImage("spiral2.jpg");
        this.logo0 = this.loadImage("gwoptics_org_logo_60px.png");
        this.paused_text = this.loadImage("paused_text.png");
        this.paused_mask = this.loadImage("paused_mask.png");
        this.blackhole_offset = PApplet.parseInt((float)((float)(50 * this.width) / 800.0f));
        this.bh1 = new Blackhole(this.blackhole_offset, this.height / 2, 60, 0);
        this.bh2 = new Blackhole(this.width - this.blackhole_offset, this.height / 2, 60, 1);
        this.stars = new ArrayList();
        this.current_background = 0;
        this.fade_level = 0;
        this.fade_timer = this.millis();
        this.controll = ControllIO.getInstance((PApplet)this);
        int n3 = this.controll.getNumberOfDevices();
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            ControllDevice controllDevice = this.controll.getDevice(n6);
            String string2 = controllDevice.getName();
            if (string2.indexOf("Mouse") != -1) {
                nArray[n4] = n6;
                ++n4;
            }
            if (string2.indexOf("Controller") != -1) {
                nArray2[n5] = n6;
                ++n5;
            }
            ++n6;
        }
        if (n5 > 1) {
            this.player1 = new Player(this, 1, 2, nArray2[0]);
            this.player2 = new Player(this, 2, 2, nArray2[1]);
        } else if (n5 > 0) {
            this.player1 = new Player(this, 1, 2, nArray2[0]);
            this.player2 = n4 > 0 && this.runningOSX ? new Player(this, 2, 1, nArray[0]) : new Player(this, 2, 0, 0);
        } else if (n4 > 1 && this.runningOSX) {
            this.player1 = new Player(this, 1, 1, nArray[0]);
            this.player2 = new Player(this, 2, 1, nArray[1]);
        } else if (n4 > 0 && this.runningOSX) {
            this.player1 = new Player(this, 1, 1, nArray[0]);
            this.player2 = new Player(this, 2, 0, 0);
        } else {
            this.player1 = new Player(this, 1, 0, 0);
            this.player2 = new Player(this, 2, 0, 0);
        }
        this.player1.set_pos(this.blackhole_offset, this.height / 2);
        this.player2.set_pos(this.width / 2 - this.blackhole_offset, this.height / 2);
        this.current_round = 0;
        this.round_init = true;
        this.screen_state = 0;
        this.credit_image = this.loadImage("credit1.png");
        this.start_image = this.loadImage("start1.png");
        this.image_loading = 0;
        this.loaded = false;
        this.paused = false;
    }

    public void draw() {
        block76: {
            block75: {
                if (this.paused) break block75;
                switch (this.screen_state) {
                    case 0: {
                        boolean bl;
                        switch (this.image_loading) {
                            case 0: {
                                this.backgrounds[0] = this.loadImage("spiral2.jpg");
                                break;
                            }
                            case 1: {
                                this.backgrounds[1] = this.loadImage("lagoon2.jpg");
                                this.music.load_sounds();
                                break;
                            }
                            case 2: {
                                this.backgrounds[2] = this.loadImage("n11_hst_800x600.jpg");
                                break;
                            }
                            case 3: {
                                this.backgrounds[3] = this.loadImage("hs-2007-17.jpg");
                                break;
                            }
                            case 4: {
                                this.backgrounds[4] = this.loadImage("hs-2007-16-800x600.jpg");
                                break;
                            }
                            case 5: {
                                this.backgrounds[5] = this.loadImage("PelicanIC5067.png");
                                break;
                            }
                            case 6: {
                                this.backgrounds[6] = this.loadImage("hs-2010-25.png");
                                break;
                            }
                            case 7: {
                                this.backgrounds[7] = this.loadImage("NGC6188_2.jpg");
                            }
                        }
                        ++this.image_loading;
                        if (this.image_loading > 7 && !this.loaded) {
                            bl = false;
                            while (bl < 8 != 0) {
                                this.image(this.backgrounds[bl], 0.0f, 0.0f);
                                this.bg = this.backgrounds[bl];
                                bl += 1;
                            }
                            this.bg = this.backgrounds[0];
                            this.loaded = true;
                        }
                        if (this.loaded) {
                            this.screen_state = 3;
                        }
                        this.image(this.start_image, 0.0f, 0.0f, this.width, this.height);
                        this.pushStyle();
                        this.textFont(this.sf2);
                        this.fill(180);
                        this.textAlign(37);
                        this.text("Loading ...", (float)(60 * this.width) / 800.0f, this.height - 50);
                        this.popStyle();
                        break;
                    }
                    case 1: 
                    case 2: {
                        int n;
                        int n2;
                        switch (this.graphics_level) {
                            case 0: {
                                this.background(128);
                                break;
                            }
                            default: {
                                this.image(this.bg, 0.0f, 0.0f);
                            }
                        }
                        this.fade();
                        this.player1.update();
                        this.player2.update();
                        this.bh1.set_to_XY(this.player1.get_Xpos(), this.player1.get_Ypos());
                        this.bh1.display();
                        this.bh2.set_to_XY(this.width / 2 + this.player2.get_Xpos(), this.player2.get_Ypos());
                        this.bh2.display();
                        boolean bl = this.player1.get_wormhole();
                        boolean bl2 = this.player2.get_wormhole();
                        boolean bl3 = this.bh1.get_wormhole();
                        boolean bl4 = this.bh2.get_wormhole();
                        if ((bl || bl3) && (bl2 || bl4)) {
                            if (bl && bl4) {
                                this.player1.remove_worm();
                                this.bh2.stop_wormhole();
                            }
                            if (bl2 && bl3) {
                                this.player2.remove_worm();
                                this.bh1.stop_wormhole();
                            }
                        } else {
                            if (bl && this.player1.has_worms()) {
                                this.bh1.init_wormhole(bl);
                                this.player1.remove_worm();
                            }
                            if (bl2 && this.player2.has_worms()) {
                                this.bh2.init_wormhole(bl2);
                                this.player2.remove_worm();
                            }
                        }
                        if (this.screen_state == 1) {
                            if (this.round_init) {
                                switch (this.current_round) {
                                    case 7: {
                                        this.player1.add_worm(100.0f);
                                        this.player1.add_worm(500.0f);
                                        this.player1.add_worm(900.0f);
                                        this.player2.add_worm(100.0f);
                                        this.player2.add_worm(500.0f);
                                        this.player2.add_worm(900.0f);
                                    }
                                }
                                this.round_init = false;
                            }
                            switch (this.current_round) {
                                case 9: {
                                    this.star_burst(2.0f, 4);
                                    break;
                                }
                                case 10: {
                                    this.star_burst(2.0f, 4);
                                    break;
                                }
                                case 12: {
                                    this.star_spiral(3.0f, 750.0f, 16);
                                    break;
                                }
                                case 13: {
                                    this.star_burst(4.0f, 8);
                                    break;
                                }
                                default: {
                                    this.one_star();
                                }
                            }
                            n2 = 0;
                            while (n2 < this.stars.size()) {
                                this.star = (Star)this.stars.get(n2);
                                this.star.display();
                                n = this.star.check_for_goal();
                                if (n > 0) {
                                    this.stars.remove(n2);
                                    if (n == 2) {
                                        this.player1.scored();
                                    }
                                    if (n == 1) {
                                        this.player2.scored();
                                    }
                                }
                                ++n2;
                            }
                            if (this.stars.size() == 0 && (float)this.millis() - this.score_timer > 2600.0f) {
                                System.gc();
                                this.star_init = true;
                                ++this.current_round;
                                this.round_init = true;
                                this.score_timer = this.millis();
                                this.bh1.stop_wormhole();
                                this.bh2.stop_wormhole();
                            }
                            if (bl3 || bl) {
                                this.bh1.draw_whirl(this.whirl1_speed);
                                this.bh2.draw_whirl(this.whirl2_speed);
                                this.whirl1_speed += 0.005f;
                            } else {
                                this.whirl1_speed = 0.01f;
                            }
                            if (bl4 || bl2) {
                                this.bh1.draw_whirl(this.whirl1_speed);
                                this.bh2.draw_whirl(this.whirl2_speed);
                                this.whirl2_speed += 0.005f;
                            } else {
                                this.whirl2_speed = 0.01f;
                            }
                        }
                        n2 = this.player1.get_score();
                        n = this.player2.get_score();
                        this.draw_score(n2, n);
                        this.player1.display_worms();
                        this.player2.display_worms();
                        if (this.current_round >= 14) {
                            this.game_over();
                        }
                        if (this.screen_state != 2) break;
                        this.pushStyle();
                        this.textFont(this.sf1);
                        this.fill(255);
                        this.textAlign(3);
                        this.text("Game Over", this.width / 2, this.height / 2);
                        this.textFont(this.sf2);
                        this.text("Press space to continue", this.width / 2, 0.83f * (float)this.height);
                        this.popStyle();
                        this.show_logo();
                    }
                }
                switch (this.screen_state) {
                    case 1: {
                        if (this.checkKey(32)) {
                            this.reset_keys();
                            this.pause();
                        }
                        if (this.hasFocus() && this.robot != null && this.runningOSX && this.use_robot) {
                            Rectangle rectangle = this.frame.getBounds();
                            this.robot.mouseMove(rectangle.x + this.width / 2, rectangle.y + this.height / 2);
                            break;
                        }
                        break block76;
                    }
                    case 2: {
                        if (this.checkKey(32)) {
                            this.player1.reset_score();
                            this.player2.reset_score();
                            System.gc();
                            this.screen_state = 3;
                            this.reset_keys();
                            this.cursor(0);
                            break;
                        }
                        break block76;
                    }
                    case 3: {
                        this.image(this.start_image, 0.0f, 0.0f, this.width, this.height);
                        this.pushStyle();
                        this.textFont(this.sf2);
                        this.fill(180);
                        this.textAlign(37);
                        this.fill(255);
                        this.text("C", (float)(60 * this.width) / 800.0f, 230.0f);
                        this.fill(180);
                        this.text("redits", (60.0f + this.textWidth("C")) * (float)this.width / 800.0f, 230.0f);
                        this.fill(255);
                        this.text("O", (float)(60 * this.width) / 800.0f, 270.0f);
                        this.fill(180);
                        this.text("ptions", (60.0f + this.textWidth("O")) * (float)this.width / 800.0f, 270.0f);
                        this.fill(180);
                        this.text("Press", (float)(60 * this.width) / 800.0f, this.height - 100);
                        this.fill(255);
                        this.text("space", (60.0f + this.textWidth("Press ")) * (float)this.width / 800.0f, this.height - 100);
                        this.fill(180);
                        this.text("to start new game", (60.0f + this.textWidth("Press space ")) * (float)this.width / 800.0f, this.height - 100);
                        this.text(VersionString, (float)this.width - this.textWidth(VersionString) - (float)(80 * this.width) / 800.0f, this.height - 100);
                        this.popStyle();
                        this.show_logo();
                        if (this.checkKey(67)) {
                            this.screen_state = 4;
                            this.all_credits.start();
                        }
                        if (this.checkKey(79)) {
                            this.screen_state = 5;
                        }
                        if (this.checkKey(32)) {
                            this.music.game();
                            this.score_timer = this.millis();
                            this.reset_keys();
                            this.current_round = 0;
                            this.round_init = true;
                            this.star_init = true;
                            this.screen_state = 1;
                            this.noCursor();
                            this.bh1.set_pos(this.blackhole_offset, this.height / 2);
                            this.bh1.make_lens();
                            this.bh2.set_pos(this.width - this.blackhole_offset, this.height / 2);
                            this.bh2.make_lens();
                            this.player1.set_pos(this.blackhole_offset, this.height / 2);
                            this.player2.set_pos(this.width / 2 - this.blackhole_offset, this.height / 2);
                            break;
                        }
                        break block76;
                    }
                    case 4: {
                        this.image(this.credit_image, 0.0f, 0.0f, this.width, this.height);
                        if (this.all_credits.display() || this.checkKey(32) || this.checkKey(27)) {
                            this.screen_state = 3;
                            this.reset_keys();
                            break;
                        }
                        break block76;
                    }
                    case 5: {
                        this.image(this.credit_image, 0.0f, 0.0f, this.width, this.height);
                        float f = 400.0f;
                        this.fill(255);
                        this.text("S", (float)(60 * this.width) / 800.0f, f);
                        this.fill(180);
                        this.text("ound:", (60.0f + this.textWidth("S")) * (float)this.width / 800.0f, f);
                        this.fill(255);
                        if (this.Osound) {
                            this.text("ON", (60.0f + this.textWidth("Sound:  ")) * (float)this.width / 800.0f, f);
                        } else {
                            this.text("OFF", (60.0f + this.textWidth("Sound:  ")) * (float)this.width / 800.0f, f);
                        }
                        this.fill(255);
                        this.text("M", (float)(60 * this.width) / 800.0f, f += 50.0f);
                        this.fill(180);
                        this.text("usic:", (60.0f + this.textWidth("M")) * (float)this.width / 800.0f, f);
                        this.fill(255);
                        if (this.Omusic) {
                            this.text("ON", (60.0f + this.textWidth("Music:  ")) * (float)this.width / 800.0f, f);
                        } else {
                            this.text("OFF", (60.0f + this.textWidth("Music:  ")) * (float)this.width / 800.0f, f);
                        }
                        this.fill(255);
                        this.text("G", (float)(60 * this.width) / 800.0f, f += 50.0f);
                        this.fill(180);
                        this.text("raphical detail:", (60.0f + this.textWidth("G")) * (float)this.width / 800.0f, f);
                        this.fill(255);
                        this.text(this.graphics_level, (60.0f + this.textWidth("Graphical detail:  ")) * (float)this.width / 800.0f, f);
                        if (this.checkKey(83)) {
                            this.Osound = !this.Osound;
                            this.reset_keys();
                        }
                        if (this.checkKey(77)) {
                            if (this.Omusic) {
                                this.Omusic = false;
                                this.music.mute();
                            } else {
                                this.Omusic = true;
                                this.music.unmute();
                            }
                            this.reset_keys();
                        }
                        if (this.checkKey(71)) {
                            ++this.graphics_level;
                            if (this.graphics_level > 3) {
                                this.graphics_level = 0;
                            }
                            this.reset_keys();
                        }
                        if (!this.checkKey(32) && !this.checkKey(27)) break block76;
                        this.screen_state = 3;
                        this.reset_keys();
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block76;
            }
            this.background(0);
            this.pushStyle();
            this.tint(240.0f, 240.0f, 255.0f, 200.0f);
            this.image(this.paused_background, 0.0f, 0.0f);
            this.noTint();
            this.image(this.paused_image, 0.0f, 0.0f);
            this.image(this.paused_text, 0.0f, 0.0f);
            this.popStyle();
            if (this.checkKey(32)) {
                this.reset_keys();
                this.unpause();
            }
        }
    }

    public void one_star() {
        if (this.star_init && (float)this.millis() - this.score_timer > 2500.0f) {
            this.star = new Star(this.bh1, this.bh2);
            this.stars.add(this.star);
            this.star_init = false;
        }
    }

    public void star_spiral(float f, float f2, int n) {
        float f3 = f2;
        if ((float)this.millis() - this.score_timer > 2500.0f) {
            if (this.star_init) {
                this.star_init = false;
                this.star_timer = this.millis();
                f3 = 0.0f;
                this.star_count = 0;
            }
            if (this.star_count < n && (float)this.millis() - this.star_timer >= f3) {
                this.star = new Star(this.bh1, this.bh2);
                this.stars.add(this.star);
                float f4 = 1.5707964f * ((float)this.star_count + 0.5f);
                this.star.reset(PApplet.parseInt((float)(BlackholePong.cos((float)f4) * f)), PApplet.parseInt((float)(BlackholePong.sin((float)f4) * f)));
                this.star_timer = this.millis();
                ++this.star_count;
            }
        }
    }

    public void star_burst(float f, int n) {
        if (this.star_init && (float)this.millis() - this.score_timer > 2500.0f) {
            int n2 = 0;
            while (n2 < n) {
                this.star = new Star(this.bh1, this.bh2);
                this.stars.add(this.star);
                float f2 = (float)n2 * 2.0f * (float)Math.PI / (float)n;
                this.star.reset(PApplet.parseInt((float)(BlackholePong.cos((float)f2) * f)), PApplet.parseInt((float)(BlackholePong.sin((float)f2) * f)));
                ++n2;
            }
            this.star_init = false;
        }
    }

    public void draw_score(int n, int n2) {
        String string = Integer.toString(n);
        String string2 = Integer.toString(n2);
        this.pushStyle();
        this.fill(255);
        this.textFont(this.sf);
        this.textAlign(3);
        int n3 = PApplet.parseInt((float)((float)(80 * this.width) / 800.0f));
        int n4 = 4 + PApplet.parseInt((float)this.textAscent());
        this.text(string, this.width / 2 - n3, n4);
        this.text(string2, this.width / 2 + n3, n4);
        int n5 = 20;
        int n6 = 0;
        this.popStyle();
        if (this.screen_state != 2) {
            this.pushStyle();
            this.fill(255);
            this.textFont(this.sf2);
            this.textAlign(3);
            int n7 = 4 + PApplet.parseInt((float)this.textDescent());
            int n8 = PApplet.parseInt((float)this.textAscent());
            this.text("round " + Integer.toString(this.current_round + 1), this.width / 2, this.height - n7);
            this.popStyle();
            this.pushStyle();
            this.stroke(255);
            this.strokeWeight(5.0f);
            while (n6 < this.height - 2 * (n7 + n8)) {
                this.line(this.width / 2, n6, this.width / 2, n6 + n5);
                n6 += 2 * n5;
            }
            this.popStyle();
        }
    }

    public void fade() {
        int n = 0;
        switch (this.graphics_level) {
            case 3: {
                float f = this.millis();
                if (!this.fading && f - this.fade_timer > 25000.0f) {
                    this.fade_timer = f;
                    n = this.current_background + 1;
                    if (n >= 8) {
                        n = 0;
                    }
                    this.current_background = n;
                    this.fading = true;
                    this.bh1.set_fading(1);
                    this.bh2.set_fading(1);
                }
                this.tint(255, this.fade_level);
                this.image(this.backgrounds[this.current_background], 0.0f, 0.0f);
                this.noTint();
                if (!this.fading) break;
                this.fade_level += PApplet.parseInt((float)5.5555553f);
                if (this.fade_level <= 250) break;
                this.fade_level = 0;
                this.fading = false;
                this.bh1.set_fading(2);
                this.bh2.set_fading(2);
                this.bg = this.backgrounds[this.current_background];
                this.fade_timer = this.millis();
            }
        }
    }

    public void game_over() {
        this.music.play(SoundTypes.GAMEOVER, true);
        this.screen_state = 2;
        this.music.intro();
        int n = this.stars.size() - 1;
        while (n >= 0) {
            this.stars.remove(n);
            --n;
        }
        while (this.player1.has_worms()) {
            this.player1.remove_worm();
        }
        while (this.player2.has_worms()) {
            this.player2.remove_worm();
        }
    }

    public void show_logo() {
        this.pushStyle();
        this.fill(255, 40.0f);
        this.rect(0.0f, this.height - 60, this.width, this.height);
        this.popStyle();
        this.image(this.logo0, 0.5875f * (float)this.width * (float)this.width / 800.0f, this.height - 55);
    }

    public boolean checkKey(int n) {
        if (this.keys.length >= n) {
            return this.keys[n];
        }
        return false;
    }

    public void reset_keys() {
        int n = 0;
        while (n < this.keys.length) {
            this.keys[n] = false;
            ++n;
        }
    }

    public void keyPressed() {
        if (this.key == '\u001b') {
            if (this.screen_state == 1) {
                this.key = '\u0000';
                this.paused = false;
                this.game_over();
            } else if (this.screen_state > 3) {
                this.key = '\u0000';
            }
        }
        this.keys[this.keyCode] = true;
    }

    public void keyReleased() {
        this.keys[this.keyCode] = false;
    }

    public void pause() {
        this.pause_timer = this.millis();
        this.paused = true;
        this.paused_image = this.g.get();
        this.paused_background = this.g.get();
        this.paused_image.mask(this.paused_mask);
    }

    public void unpause() {
        this.paused = false;
        float f = (float)this.millis() - this.pause_timer;
        this.fade_timer += f;
        this.star_timer += f;
        this.score_timer += f;
        this.bh1.set_timer(f);
        this.bh2.set_timer(f);
        int n = this.stars.size() - 1;
        while (n >= 0) {
            Star star = (Star)this.stars.get(n);
            star.set_timer(f);
            --n;
        }
    }

    public void stop() {
        this.cursor();
        this.music.stop();
        super.stop();
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--present", "--bgcolor=#000000", "--hide-stop", "BlackholePong"});
    }

    class Blackhole {
        static final float inner_diameter = 0.5f;
        static final float wormhole_delay = 1500.0f;
        private PImage bh_source;
        private PImage bh_image;
        private final PImage whirl_image;
        private int[] effectArray;
        private int bh_width;
        private int bhxpos;
        private int bhypos;
        private int oldxpos;
        private int oldypos;
        private int ellipse_width;
        private int fade_level;
        private int fading;
        private int left_right;
        boolean wormhole;
        float wormhole_timer;
        float rot_angle;

        Blackhole(int n, int n2, int n3, int n4) {
            this.whirl_image = BlackholePong.this.loadImage("whirl2.png");
            this.fade_level = 255;
            this.rot_angle = 0.0f;
            this.bh_width = n3;
            this.fading = 0;
            this.left_right = n4;
            this.bhxpos = n;
            this.bhypos = n2;
            this.oldxpos = 0;
            this.oldypos = 0;
            this.bh_source = BlackholePong.this.createImage(this.bh_width, this.bh_width, 1);
            this.bh_image = BlackholePong.this.createImage(this.bh_width, this.bh_width, 1);
            this.bh_array(this.bh_width);
            this.make_lens();
            this.ellipse_width = BlackholePong.round((float)((float)this.bh_width * 0.5f)) + 4;
            this.wormhole = false;
        }

        public void display() {
            switch (BlackholePong.this.graphics_level) {
                case 0: 
                case 1: {
                    this.draw_ellipse();
                    break;
                }
                case 2: 
                case 3: {
                    if (this.fading != 0 || this.oldxpos != this.bhxpos || this.oldypos != this.bhypos) {
                        this.make_lens();
                    }
                    switch (this.fading) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.fade_level -= 40;
                            if (this.fade_level >= 0) break;
                            this.fade_level = 0;
                            this.fading = 0;
                            break;
                        }
                        case 2: {
                            this.fade_level += 15;
                            if (this.fade_level <= 255) break;
                            this.fade_level = 255;
                            this.fading = 0;
                        }
                    }
                    BlackholePong.this.pushStyle();
                    BlackholePong.this.imageMode(3);
                    BlackholePong.this.tint(255, this.fade_level);
                    BlackholePong.this.image(this.bh_image, this.bhxpos, this.bhypos, this.bh_width, this.bh_width);
                    BlackholePong.this.noTint();
                    BlackholePong.this.popStyle();
                    this.draw_ellipse();
                }
            }
        }

        public void make_lens() {
            int n;
            int n2 = BlackholePong.this.width - this.bhxpos + this.bh_width / 2;
            if (n2 >= this.bh_width) {
                n2 = this.bh_width;
            }
            if ((n = BlackholePong.this.height - this.bhypos + this.bh_width / 2) >= this.bh_width) {
                n = this.bh_width;
            }
            int n3 = 0;
            if (this.bhxpos - this.bh_width / 2 < 0) {
                n3 = this.bhxpos;
            }
            int n4 = 0;
            if (this.bhypos - this.bh_width / 2 < 0) {
                n4 = this.bhypos;
            }
            this.bh_source.copy(BlackholePong.this.bg, this.bhxpos - n3 - this.bh_width / 2, this.bhypos - n4 - this.bh_width / 2, n2 + n3, n + n4, -1 * n3, -1 * n4, n2 + n3, n + n4);
            this.bh_source.pixels[this.bh_width * this.bh_width / 2 + this.bh_width / 2] = BlackholePong.this.color(5, 5, 15);
            this.bh_image.loadPixels();
            int n5 = 0;
            while (n5 < this.bh_image.pixels.length) {
                this.bh_image.pixels[n5] = this.bh_source.pixels[this.effectArray[n5]];
                ++n5;
            }
            this.bh_image.updatePixels();
        }

        public void set_to_XY(int n, int n2) {
            this.oldxpos = this.bhxpos;
            this.oldypos = this.bhypos;
            if (n > 0 && n < BlackholePong.this.width) {
                if (this.left_right == 0) {
                    if (n < BlackholePong.this.width / 2 - this.bh_width / 2) {
                        this.bhxpos = n;
                    }
                } else if (n > BlackholePong.this.width / 2 + this.bh_width / 2) {
                    this.bhxpos = n;
                }
            }
            if (n2 > 0 && n2 < BlackholePong.this.height) {
                this.bhypos = n2;
            }
        }

        public int get_xPos() {
            return this.bhxpos;
        }

        public int get_yPos() {
            return this.bhypos;
        }

        public void init_wormhole(boolean bl) {
            if (!this.wormhole && bl) {
                this.wormhole_timer = BlackholePong.this.millis();
                this.wormhole = true;
                BlackholePong.this.music.play(SoundTypes.WORMHOLE, true);
            }
        }

        public void set_timer(float f) {
            this.wormhole_timer += f;
        }

        public void stop_wormhole() {
            this.wormhole = false;
        }

        public boolean get_wormhole() {
            if (this.wormhole && (float)BlackholePong.this.millis() - this.wormhole_timer > 1500.0f) {
                this.wormhole = false;
            }
            return this.wormhole;
        }

        public void set_pos(int n, int n2) {
            this.oldxpos = this.bhxpos;
            this.oldypos = this.bhypos;
            this.bhxpos = n;
            this.bhypos = n2;
        }

        public void draw_ellipse() {
            BlackholePong.this.pushStyle();
            BlackholePong.this.fill(5.0f, 5.0f, 15.0f);
            BlackholePong.this.ellipseMode(3);
            BlackholePong.this.ellipse(this.bhxpos + 1, this.bhypos + 1, this.ellipse_width, this.ellipse_width);
            BlackholePong.this.popStyle();
        }

        public void draw_whirl(float f) {
            BlackholePong.this.pushMatrix();
            BlackholePong.this.pushStyle();
            BlackholePong.this.imageMode(3);
            BlackholePong.this.translate(this.bhxpos, this.bhypos);
            BlackholePong.this.rotate(this.rot_angle);
            BlackholePong.this.translate(-this.bhxpos, -this.bhypos);
            this.rot_angle += f * 100.0f / 90.0f;
            BlackholePong.this.image(this.whirl_image, this.bhxpos, this.bhypos);
            BlackholePong.this.popStyle();
            BlackholePong.this.popMatrix();
        }

        public void set_fading(int n) {
            this.fading = n;
        }

        public void bh_array(int n) {
            this.effectArray = new int[n * n];
            int n2 = n / 2;
            float f = n2;
            float f2 = 0.5f * (float)n2;
            int n3 = -n2;
            while (n3 < n2) {
                int n4 = -n2;
                while (n4 < n2) {
                    int n5;
                    int n6;
                    float f3 = BlackholePong.atan2((float)n3, (float)n4);
                    float f4 = n4 * n4 + n3 * n3;
                    if (f4 <= f2 * f2) {
                        n6 = 0;
                        n5 = 0;
                    } else if (f4 >= f * f) {
                        n6 = n4;
                        n5 = n3;
                    } else {
                        float f5 = (BlackholePong.sqrt((float)f4) - f2) / (f - f2);
                        f5 = f5 * f5 * f;
                        n6 = BlackholePong.round((float)(f5 * BlackholePong.cos((float)f3)));
                        n5 = BlackholePong.round((float)(f5 * BlackholePong.sin((float)f3)));
                    }
                    this.effectArray[(n3 + n2) * n + (n4 + n2)] = (n5 + n2) * n + (n6 + n2);
                    ++n4;
                }
                ++n3;
            }
        }
    }

    class Credits {
        float xpos0 = 15.0f;
        float ypos0 = 700.0f;
        float speed = 0.05f;
        float timer;

        Credits() {
        }

        public void start() {
            this.timer = BlackholePong.this.millis();
        }

        public boolean display() {
            BlackholePong.this.pushMatrix();
            BlackholePong.this.pushStyle();
            float f = this.xpos0;
            float f2 = this.ypos0 - this.speed * ((float)BlackholePong.this.millis() - this.timer);
            BlackholePong.this.textFont(BlackholePong.this.sf1);
            BlackholePong.this.textAlign(3);
            BlackholePong.this.fill(220, 130.0f);
            this.mytext("credits", BlackholePong.this.width / 2, f2);
            BlackholePong.this.textFont(BlackholePong.this.sf3);
            BlackholePong.this.fill(180.0f, 0.0f, 0.0f);
            this.mytext("code", BlackholePong.this.width / 2, f2 += 70.0f);
            BlackholePong.this.textFont(BlackholePong.this.sf2);
            BlackholePong.this.textAlign(37);
            BlackholePong.this.textFont(BlackholePong.this.sf2);
            BlackholePong.this.fill(255);
            String string = new String("physics engine:");
            this.mytext(string, f, f2 += 60.0f);
            BlackholePong.this.fill(188);
            this.mytext(" Robert Unwin", f + BlackholePong.this.textWidth(string), f2);
            BlackholePong.this.fill(255);
            string = new String("graphical effects and game design:");
            this.mytext(string, f, f2 += 40.0f);
            BlackholePong.this.fill(188);
            this.mytext(" Andreas Freise", f + BlackholePong.this.textWidth(string), f2);
            BlackholePong.this.fill(255);
            string = new String("black hole lens ");
            this.mytext(string, f, f2 += 40.0f);
            BlackholePong.this.fill(188);
            this.mytext(" based on the example by luis2048,", f + BlackholePong.this.textWidth(string), f2);
            this.mytext("http://processing.org/learning/topics/lens.html", f, f2 += 30.0f);
            BlackholePong.this.fill(255);
            string = new String("procontroll library ");
            this.mytext(string, f, f2 += 40.0f);
            BlackholePong.this.fill(188);
            this.mytext(" by Christian Riekoff (LGPL 2.1),", f + BlackholePong.this.textWidth(string), f2);
            this.mytext("http://creativecomputing.cc/p5libs/procontroll/", f, f2 += 30.0f);
            BlackholePong.this.fill(255);
            string = new String("help with procontroll library:");
            this.mytext(string, f, f2 += 40.0f);
            BlackholePong.this.fill(188);
            this.mytext(" Yelele (at http://www.yelele.eu)", f + BlackholePong.this.textWidth(string), f2);
            BlackholePong.this.fill(255);
            string = new String("built with Processing:");
            this.mytext(string, f, f2 += 40.0f);
            BlackholePong.this.fill(188);
            this.mytext(" http://www.processing.org", f + BlackholePong.this.textWidth(string), f2);
            BlackholePong.this.textFont(BlackholePong.this.sf3);
            BlackholePong.this.textAlign(3);
            BlackholePong.this.fill(180.0f, 0.0f, 0.0f);
            this.mytext("background images", BlackholePong.this.width / 2, f2 += 70.0f);
            BlackholePong.this.textFont(BlackholePong.this.sf2);
            BlackholePong.this.textAlign(37);
            BlackholePong.this.fill(255);
            this.mytext("Three Nebulae in Narrow Band", f, f2 += 60.0f);
            BlackholePong.this.fill(180);
            this.mytext("Credit & Copyright:  Michael Mayda", f, f2 += 30.0f);
            this.mytext("http://apod.nasa.gov/apod/ap071102.html", f, f2 += 30.0f);
            BlackholePong.this.fill(255);
            this.mytext("Pelican Nebula", f, f2 += 50.0f);
            BlackholePong.this.fill(180);
            this.mytext("Credit & Copyright: Tony Hallas ", f, f2 += 30.0f);
            this.mytext("http://apod.nasa.gov/apod/ap100819.html", f, f2 += 30.0f);
            BlackholePong.this.fill(255);
            this.mytext("Shaping NGC 6188", f, f2 += 50.0f);
            BlackholePong.this.fill(180);
            this.mytext("Credit & Copyright:  Piotrek Sadowski ", f, f2 += 30.0f);
            this.mytext("http://www.astrofotografia.com.pl/photogallery/6188/ngc6188.htm", f, f2 += 30.0f);
            BlackholePong.this.fill(255);
            this.mytext("Out of This Whirl: the Whirlpool Galaxy (M51) and Companion Galaxy", f, f2 += 50.0f);
            BlackholePong.this.fill(180);
            this.mytext("Credit: NASA, ESA, S. Beckwith (STScI), and The Hubble Heritage Team", f, f2 += 30.0f);
            this.mytext("(STScI/AURA)", f, f2 += 30.0f);
            this.mytext("http://imgsrc.hubblesite.org/", f, f2 += 30.0f);
            BlackholePong.this.fill(255);
            this.mytext("N11, the Second-Largest Star Formation Region in the Large Magellanic", f, f2 += 50.0f);
            this.mytext("Cloud", f, f2 += 30.0f);
            BlackholePong.this.fill(180);
            this.mytext("Credit: NASA, ESA, The Hubble Heritage Team (AURA/STScI), and HEIC", f, f2 += 30.0f);
            this.mytext("Acknowledgment: Y.-H. Chu (U. Illinois, Urbana-Champaign) and ", f, f2 += 30.0f);
            this.mytext("Y\u00e4el Naz\u00e9 (U. Li\u00e8ge, Belgium)", f, f2 += 30.0f);
            this.mytext("http://imgsrc.hubblesite.org/", f, f2 += 30.0f);
            BlackholePong.this.fill(255);
            this.mytext("Carina Nebula Details: Great Clouds", f, f2 += 50.0f);
            BlackholePong.this.fill(180);
            this.mytext("Credit for Hubble Image: NASA, ESA, N. Smith (University of California,", f, f2 += 30.0f);
            this.mytext("Berkeley), and The Hubble Heritage Team (STScI/AURA)", f, f2 += 30.0f);
            this.mytext("Credit for CTIO Image: N. Smith (University of California, Berkeley)", f, f2 += 30.0f);
            this.mytext("http://imgsrc.hubblesite.org/", f, f2 += 30.0f);
            BlackholePong.this.fill(255);
            this.mytext("M72: A Globular Cluster of Stars", f, f2 += 50.0f);
            BlackholePong.this.fill(180);
            this.mytext("Credit: NASA, ESA, Hubble, HPOW", f, f2 += 30.0f);
            this.mytext("http://apod.nasa.gov/apod/ap100512.html", f, f2 += 30.0f);
            BlackholePong.this.fill(255);
            this.mytext("Hubble Finds Dark Matter Ring in Galaxy Cluster", f, f2 += 50.0f);
            BlackholePong.this.fill(180);
            this.mytext("Credit: NASA, ESA, M.J. Jee and H. Ford (Johns Hopkins University)", f, f2 += 30.0f);
            this.mytext("http://imgsrc.hubblesite.org/", f, f2 += 30.0f);
            BlackholePong.this.fill(255);
            this.mytext("A Galactic Spectacle", f, f2 += 50.0f);
            BlackholePong.this.fill(180);
            this.mytext("Credit: NASA, ESA, SAO, CXC, JPL-Caltech, and STScI", f, f2 += 30.0f);
            this.mytext("Acknowledgment: J. DePasquale (Harvard-Smithsonian CfA), and", f, f2 += 30.0f);
            this.mytext("B. Whitmore (STScI), http://imgsrc.hubblesite.org/", f, f2 += 30.0f);
            BlackholePong.this.textFont(BlackholePong.this.sf3);
            BlackholePong.this.textAlign(3);
            BlackholePong.this.fill(180.0f, 0.0f, 0.0f);
            this.mytext("music and sound", BlackholePong.this.width / 2, f2 += 70.0f);
            BlackholePong.this.textFont(BlackholePong.this.sf2);
            BlackholePong.this.textAlign(37);
            BlackholePong.this.fill(255);
            string = new String("Flood loop ");
            this.mytext(string, f, f2 += 60.0f);
            BlackholePong.this.fill(180);
            this.mytext("by genghis attenborough", f + BlackholePong.this.textWidth(string), f2);
            this.mytext("http://www.freesound.org/samplesViewSingle.php?id=32274", f, f2 += 30.0f);
            this.mytext("Creative Commons Sampling Plus 1.0 License", f, f2 += 30.0f);
            BlackholePong.this.fill(255);
            string = new String("Shaker, Woda, Conga, Bongo, Templeblock ");
            this.mytext(string, f, f2 += 50.0f);
            BlackholePong.this.fill(180);
            this.mytext("by kwazi", f + BlackholePong.this.textWidth(string), f2);
            this.mytext("http://www.freesound.org/samplesViewSingle.php?id=34115", f, f2 += 30.0f);
            this.mytext("Creative Commons Sampling Plus 1.0 License", f, f2 += 30.0f);
            BlackholePong.this.fill(255);
            string = new String("supernova fx ");
            this.mytext(string, f, f2 += 50.0f);
            BlackholePong.this.fill(180);
            this.mytext("by serkantemiz", f + BlackholePong.this.textWidth(string), f2);
            this.mytext("http://www.freesound.org/samplesViewSingle.php?id=1797", f, f2 += 30.0f);
            this.mytext("Creative Commons Sampling Plus 1.0 License", f, f2 += 30.0f);
            BlackholePong.this.fill(255);
            string = new String("909_EH_kick2 ");
            this.mytext(string, f, f2 += 50.0f);
            BlackholePong.this.fill(180);
            this.mytext("by helitron", f + BlackholePong.this.textWidth(string), f2);
            this.mytext("http://www.freesound.org/samplesViewSingle.php?id=7811", f, f2 += 30.0f);
            this.mytext("Creative Commons Sampling Plus 1.0 License", f, f2 += 30.0f);
            BlackholePong.this.fill(255);
            string = new String("jetbike flypast ");
            this.mytext(string, f, f2 += 50.0f);
            BlackholePong.this.fill(180);
            this.mytext("by tigersound", f + BlackholePong.this.textWidth(string), f2);
            this.mytext("http://www.freesound.org/samplesViewSingle.php?id=9088", f, f2 += 30.0f);
            this.mytext("Creative Commons Sampling Plus 1.0 License", f, f2 += 30.0f);
            BlackholePong.this.fill(255);
            string = new String("MemoryMoon_space-blaster-plays ");
            this.mytext(string, f, f2 += 50.0f);
            BlackholePong.this.fill(180);
            this.mytext("by suonho", f + BlackholePong.this.textWidth(string), f2);
            this.mytext("http://www.freesound.org/samplesViewSingle.php?id=27568", f, f2 += 30.0f);
            this.mytext("Creative Commons Sampling Plus 1.0 License", f, f2 += 30.0f);
            BlackholePong.this.fill(255);
            string = new String("bitline4A ");
            this.mytext(string, f, f2 += 50.0f);
            BlackholePong.this.fill(180);
            this.mytext("by meowtek", f + BlackholePong.this.textWidth(string), f2);
            this.mytext("http://www.freesound.org/samplesViewSingle.php?id=69219", f, f2 += 30.0f);
            this.mytext("Creative Commons Sampling Plus 1.0 License", f, f2 += 30.0f);
            BlackholePong.this.fill(255);
            string = new String("thudkick ");
            this.mytext(string, f, f2 += 50.0f);
            BlackholePong.this.fill(180);
            this.mytext("by A43", f + BlackholePong.this.textWidth(string), f2);
            this.mytext("http://www.freesound.org/samplesViewSingle.php?id=9700", f, f2 += 30.0f);
            this.mytext("Creative Commons Sampling Plus 1.0 License", f, f2 += 30.0f);
            BlackholePong.this.fill(255);
            string = new String("Dark church bell ");
            this.mytext(string, f, f2 += 50.0f);
            BlackholePong.this.fill(180);
            this.mytext("by DJ Chronos", f + BlackholePong.this.textWidth(string), f2);
            this.mytext("http://www.freesound.org/samplesViewSingle.php?id=45137", f, f2 += 30.0f);
            this.mytext("Creative Commons Sampling Plus 1.0 License", f, f2 += 30.0f);
            BlackholePong.this.fill(255);
            string = new String("gasmask ");
            this.mytext(string, f, f2 += 50.0f);
            BlackholePong.this.fill(180);
            this.mytext("by DaveOfDefeat2248", f + BlackholePong.this.textWidth(string), f2);
            this.mytext("http://www.freesound.org/samplesViewSingle.php?id=87557", f, f2 += 30.0f);
            this.mytext("Creative Commons Sampling Plus 1.0 License", f, f2 += 30.0f);
            BlackholePong.this.popStyle();
            BlackholePong.this.popMatrix();
            return f2 < -100.0f;
        }

        public void mytext(String string, float f, float f2) {
            if (f2 > -100.0f && f2 < (float)(BlackholePong.this.height + 100)) {
                BlackholePong.this.text(string, f, f2);
            }
        }
    }

    class Player {
        static final int speed_inc = 10;
        static final float friction = 0.97f;
        static final float controller_scale = 8.888889f;
        static final float controller_tolerance = 0.1f;
        static final float threshold = 0.1f;
        static final int BUTTON1 = 0;
        static final int BUTTON2 = 1;
        final int wormhole_threshold = PApplet.parseInt((float)30.0f);
        final int wormhole_penalty = PApplet.parseInt((float)180.0f);
        ArrayList worms;
        ControllSlider sX;
        ControllSlider sY;
        int xpos;
        int ypos;
        int xspeed;
        int yspeed;
        int player_number;
        int score;
        float horizon;
        boolean boost;
        boolean wormhole;
        int wormhole_count;
        int input_method;
        int device_number;
        ControllDevice device;
        ControllButton[] buttons;
        int num_buttons = 0;

        Player(PApplet pApplet, int n, int n2, int n3) {
            this.player_number = n;
            this.xpos = 0;
            this.ypos = 0;
            this.xspeed = 0;
            this.yspeed = 0;
            this.score = 0;
            this.input_method = n2;
            this.device_number = n3;
            this.horizon = 1.2f;
            this.wormhole_count = 0;
            this.worms = new ArrayList();
            switch (this.input_method) {
                case 2: {
                    this.device = BlackholePong.this.controll.getDevice(this.device_number);
                    String string = this.device.getName();
                    if (string.indexOf("Controller") != -1) {
                        BlackholePong.println((String)("Player " + this.player_number + ": Found Xbox controller in device " + this.device_number));
                    }
                    this.device.setTolerance(0.1f);
                    this.num_buttons = 2;
                    this.buttons = new ControllButton[this.num_buttons];
                    if (BlackholePong.this.runningOSX) {
                        this.buttons[0] = this.device.getButton(8);
                        this.buttons[1] = this.device.getButton(9);
                    } else {
                        this.buttons[0] = this.device.getButton(4);
                        this.buttons[1] = this.device.getButton(5);
                    }
                    if (BlackholePong.this.runningOSX) {
                        this.sX = this.device.getSlider(0);
                        this.sY = this.device.getSlider(1);
                        break;
                    }
                    this.sX = this.device.getSlider(1);
                    this.sY = this.device.getSlider(0);
                    break;
                }
                case 1: {
                    this.device = BlackholePong.this.controll.getDevice(this.device_number);
                    String string = this.device.getName();
                    if (string.indexOf("Mouse") != -1) {
                        BlackholePong.println((String)("Player " + this.player_number + ": Found mouse in device " + this.device_number));
                    }
                    this.num_buttons = 2;
                    this.buttons = new ControllButton[this.num_buttons];
                    this.buttons[0] = this.device.getButton(0);
                    this.buttons[1] = this.device.getButton(1);
                    this.sX = this.device.getSlider(0);
                    this.sY = this.device.getSlider(1);
                }
            }
        }

        public void reset_score() {
            this.score = 0;
        }

        public float get_horizon() {
            return this.horizon;
        }

        public void update() {
            float f = 0.0f;
            float f2 = 0.0f;
            this.boost = false;
            switch (this.input_method) {
                case 2: {
                    f = 8.888889f * this.check_tolerance(this.sX.getValue());
                    f2 = 8.888889f * this.check_tolerance(this.sY.getValue());
                    break;
                }
                case 1: {
                    if (BlackholePong.this.runningOSX) {
                        f = this.sX.getValue();
                        f2 = this.sY.getValue();
                        break;
                    }
                    f = this.sX.getValue() * 0.01f;
                    f2 = this.sY.getValue() * 0.01f;
                    break;
                }
                case 0: {
                    this.get_keys();
                    this.add_speed();
                }
            }
            if (!BlackholePong.this.runningOSX && this.input_method == 1) {
                this.xpos = PApplet.parseInt((float)((float)BlackholePong.this.mouseX * 0.5f));
                this.ypos = BlackholePong.this.mouseY;
            } else if (this.input_method > 0) {
                this.xpos += PApplet.parseInt((float)f);
                this.ypos += PApplet.parseInt((float)f2);
            }
            if (this.input_method > 0) {
                if (this.check_button1()) {
                    this.boost = true;
                }
                if (this.check_button2()) {
                    ++this.wormhole_count;
                } else if (this.wormhole_count > 0) {
                    this.wormhole_count = 0;
                }
            }
            this.check_pos();
            if (this.boost) {
                this.horizon = 3.0f;
                BlackholePong.this.music.play(SoundTypes.BOOST, true);
            } else {
                this.horizon = 1.2f;
            }
        }

        public void check_pos() {
            if (this.xpos < 0) {
                this.xpos = 0;
                this.xspeed = 0;
            }
            if (this.xpos > BlackholePong.this.width / 2) {
                this.xpos = BlackholePong.this.width / 2;
                this.xspeed = 0;
            }
            if (this.ypos < 0) {
                this.ypos = 0;
                this.yspeed = 0;
            }
            if (this.ypos > BlackholePong.this.height) {
                this.ypos = BlackholePong.this.height;
                this.yspeed = 0;
            }
        }

        public void get_keys() {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            switch (this.player_number) {
                case 1: {
                    if (BlackholePong.this.checkKey(65)) {
                        bl4 = true;
                    }
                    if (BlackholePong.this.checkKey(68)) {
                        bl3 = true;
                    }
                    if (BlackholePong.this.checkKey(87)) {
                        bl = true;
                    }
                    if (BlackholePong.this.checkKey(83)) {
                        bl2 = true;
                    }
                    if (BlackholePong.this.checkKey(9)) {
                        this.boost = true;
                    }
                    if (BlackholePong.this.checkKey(49)) {
                        ++this.wormhole_count;
                        break;
                    }
                    if (this.wormhole_count <= 0) break;
                    this.wormhole_count = 0;
                    break;
                }
                case 2: {
                    if (BlackholePong.this.checkKey(37)) {
                        bl4 = true;
                    }
                    if (BlackholePong.this.checkKey(39)) {
                        bl3 = true;
                    }
                    if (BlackholePong.this.checkKey(38)) {
                        bl = true;
                    }
                    if (BlackholePong.this.checkKey(40)) {
                        bl2 = true;
                    }
                    if (BlackholePong.this.checkKey(10)) {
                        this.boost = true;
                    }
                    if (BlackholePong.this.checkKey(8)) {
                        ++this.wormhole_count;
                        break;
                    }
                    if (this.wormhole_count <= 0) break;
                    this.wormhole_count = 0;
                }
            }
            if (bl && !bl2) {
                this.yspeed += 10;
            }
            if (!bl && bl2) {
                this.yspeed -= 10;
            }
            if (!bl4 && bl3) {
                this.xspeed += 10;
            }
            if (bl4 && !bl3) {
                this.xspeed -= 10;
            }
        }

        public void add_speed() {
            if (this.xspeed != 0 || this.yspeed != 0) {
                this.xpos += PApplet.parseInt((float)(0.027777778f * (float)this.xspeed));
                this.ypos -= PApplet.parseInt((float)(0.027777778f * (float)this.yspeed));
                this.xspeed = PApplet.parseInt((float)((float)this.xspeed * 0.97f));
                this.yspeed = PApplet.parseInt((float)((float)this.yspeed * 0.97f));
            }
        }

        public void scored() {
            ++this.score;
        }

        public int get_score() {
            return this.score;
        }

        public int get_Xpos() {
            return this.xpos;
        }

        public int get_Ypos() {
            return this.ypos;
        }

        public void set_pos(int n, int n2) {
            this.xpos = n;
            this.ypos = n2;
        }

        public float check_tolerance(float f) {
            float f2 = f;
            f2 = BlackholePong.abs((float)f2) > 0.1f ? (f2 > 0.0f ? (f2 -= 0.1f) : (f2 += 0.1f)) : 0.0f;
            return f2;
        }

        public boolean get_wormhole() {
            if (this.wormhole_count > this.wormhole_threshold) {
                this.wormhole = true;
                this.wormhole_count = -this.wormhole_penalty;
            } else {
                this.wormhole = false;
            }
            return this.wormhole;
        }

        public boolean check_buttons() {
            boolean bl = false;
            int n = 0;
            while (n < this.num_buttons) {
                if (this.buttons[n].pressed()) {
                    bl = true;
                }
                ++n;
            }
            return bl;
        }

        public void add_worm(float f) {
            Worm worm = new Worm(f, this.player_number);
            this.worms.add(worm);
        }

        public void remove_worm() {
            if (this.worms.size() > 0) {
                this.worms.remove(this.worms.size() - 1);
            }
        }

        public void display_worms() {
            int n = 0;
            int n2 = 0;
            while (n2 < this.worms.size()) {
                Worm worm = (Worm)this.worms.get(n2);
                if (worm.is_ready()) {
                    worm.display(n);
                    ++n;
                }
                ++n2;
            }
        }

        public boolean has_worms() {
            return this.worms.size() > 0;
        }

        public boolean check_button1() {
            return this.buttons[0].pressed();
        }

        public boolean check_button2() {
            return this.buttons[1].pressed();
        }
    }

    class Sound {
        static final int maxsong = 2;
        static final int maxsample = 8;
        AudioPlayer[] song = new AudioPlayer[2];
        AudioPlayer[] samp = new AudioPlayer[8];
        int[] song_gain = new int[]{-25, -5};

        Sound() {
        }

        public void load_sounds() {
            this.song[0] = BlackholePong.this.minim.loadFile("32274__genghis_attenborough__Flood_loop.wav", 4096);
            this.song[1] = BlackholePong.this.minim.loadFile("34115__kwazi__Shaker_Woda_Conga_Bongo_Templeblock.wav", 2048);
            this.song[0].setGain(-80.0f);
            this.song[0].play();
            this.song[0].loop();
            this.song[1].shiftGain(-80.0f, (float)this.song_gain[1], 1000);
            this.song[1].play();
            this.song[1].loop();
            this.samp[0] = BlackholePong.this.minim.loadFile("9088__tigersound__jetbike_flypast.aif", 512);
            this.samp[0].setGain(-10.0f);
            this.samp[1] = BlackholePong.this.minim.loadFile("27568__suonho__MemoryMoon_space_blaster_plays.aiff", 512);
            this.samp[1].setGain(-15.0f);
            this.samp[2] = BlackholePong.this.minim.loadFile("7811__helitron__909_EH_kick2.wav", 512);
            this.samp[2].setGain(-20.0f);
            this.samp[3] = BlackholePong.this.minim.loadFile("69219__meowtek__bitline4A.wav", 512);
            this.samp[3].setGain(-23.0f);
            this.samp[4] = BlackholePong.this.minim.loadFile("1797__serkantemiz__supernova_fx.wav", 512);
            this.samp[4].setGain(-15.0f);
            this.samp[5] = BlackholePong.this.minim.loadFile("9700__A43__A43_thudkick.aif", 512);
            this.samp[5].setGain(-15.0f);
            this.samp[6] = BlackholePong.this.minim.loadFile("45137__DJ_Chronos__Dark_church_bell.wav", 512);
            this.samp[6].setGain(0.0f);
            this.samp[7] = BlackholePong.this.minim.loadFile("87557__DaveOfDefeat2248__gasmask_trim.wav", 512);
            this.samp[7].setGain(-17.0f);
        }

        public void play(SoundTypes soundTypes, boolean bl) {
            int n = 0;
            switch (soundTypes) {
                case STARBIRTH: {
                    n = 3;
                    break;
                }
                case BOUNCE: {
                    n = 2;
                    break;
                }
                case GOAL: {
                    n = 1;
                    break;
                }
                case WOOSH: {
                    n = 0;
                    break;
                }
                case WORMHOLE: {
                    n = 4;
                    break;
                }
                case NEWWORM: {
                    n = 5;
                    break;
                }
                case GAMEOVER: {
                    n = 6;
                    break;
                }
                case BOOST: {
                    n = 7;
                }
            }
            if (!(!BlackholePong.this.Osound || this.samp[n].isPlaying() && bl)) {
                this.samp[n].play(0);
            }
        }

        public void intro() {
            if (BlackholePong.this.Omusic) {
                this.song[0].shiftGain((float)this.song_gain[0], -80.0f, 5000);
                this.song[1].shiftGain(-80.0f, (float)this.song_gain[1], 2000);
            }
        }

        public void mute() {
            this.song[0].setGain(-80.0f);
            this.song[1].setGain(-80.0f);
        }

        public void unmute() {
            this.song[1].shiftGain(-80.0f, (float)this.song_gain[1], 500);
        }

        public void game() {
            if (BlackholePong.this.Omusic) {
                this.song[0].shiftGain(-80.0f, (float)this.song_gain[0], 2000);
                this.song[1].shiftGain((float)this.song_gain[1], -80.0f, 5000);
            }
        }

        public void stop() {
            int n = 0;
            while (n < 2) {
                if (this.song[n] != null) {
                    this.song[n].close();
                }
                ++n;
            }
            n = 0;
            while (n < 8) {
                if (this.samp[n] != null) {
                    this.samp[n].close();
                }
                ++n;
            }
            BlackholePong.this.minim.stop();
        }
    }

    class Star {
        private Blackhole[] bh = new Blackhole[3];
        float xpos;
        float ypos;
        float xspeed;
        float yspeed;
        float theta;
        int lost = 0;
        float[] radius_sq = new float[3];
        float[] x_diff = new float[3];
        float[] y_diff = new float[3];
        int[] bhxpos = new int[3];
        int[] bhypos = new int[3];
        int bh_wormhole;
        int wormhole_state;
        float wormhole_timer;
        static final float wormhole_speed = 0.5f;
        boolean display;
        float newxspeed = 0.0f;
        float newyspeed = 0.0f;
        static final int starsize = 30;
        static final float bounce = 0.5f;
        static final float friction = 0.98f;
        int bound;
        static final float f_wall = 0.6666667f;
        static final float f_sink = 53.333332f;
        static final float maxspeed = 150.0f;
        private final PImage star;

        Star(Blackhole blackhole, Blackhole blackhole2) {
            this.bound = 50 * PApplet.parseInt((float)((float)BlackholePong.this.width / 800.0f));
            this.star = BlackholePong.this.loadImage("star1.png");
            this.bh[1] = blackhole;
            this.bh[2] = blackhole2;
            this.reset(0, 0);
            this.wormhole_state = 0;
            this.bh_wormhole = 0;
            this.display = true;
            BlackholePong.this.music.play(SoundTypes.STARBIRTH, false);
        }

        public void display() {
            this.update();
            this.drawStar();
        }

        public void update() {
            int n;
            this.xpos += this.xspeed * 60.0f / 90.0f;
            this.ypos += this.yspeed * 60.0f / 90.0f;
            if (this.xpos > (float)(BlackholePong.this.width - this.bound)) {
                if (this.ypos > (float)BlackholePong.this.lower_post && this.ypos < (float)BlackholePong.this.upper_post) {
                    if (this.xpos > (float)(BlackholePong.this.width + 60)) {
                        this.lost = 2;
                        BlackholePong.this.music.play(SoundTypes.GOAL, false);
                    }
                } else {
                    BlackholePong.this.music.play(SoundTypes.BOUNCE, true);
                    if (this.xpos > (float)BlackholePong.this.width) {
                        this.xspeed *= -0.5f;
                        this.xpos = (float)BlackholePong.this.width - 0.5f;
                    } else {
                        this.theta = (1.0f + (this.xpos - (float)BlackholePong.this.width) / (float)this.bound) * 1.5707964f;
                        this.xspeed += -0.6666667f * BlackholePong.tan((float)this.theta);
                        this.xspeed *= 0.98f;
                    }
                }
            }
            if (this.xpos < (float)this.bound) {
                if (this.ypos > (float)BlackholePong.this.lower_post && this.ypos < (float)BlackholePong.this.upper_post) {
                    if (this.xpos < -60.0f) {
                        this.lost = 1;
                        BlackholePong.this.music.play(SoundTypes.GOAL, false);
                    }
                } else {
                    BlackholePong.this.music.play(SoundTypes.BOUNCE, true);
                    if (this.xpos < 0.0f) {
                        this.xspeed *= -0.5f;
                        this.xpos = 0.5f;
                    } else {
                        this.theta = (1.0f - this.xpos / (float)this.bound) * 1.5707964f;
                        this.xspeed += 0.6666667f * BlackholePong.tan((float)this.theta);
                        this.xspeed *= 0.98f;
                    }
                }
            }
            if (this.ypos > (float)(BlackholePong.this.height - this.bound)) {
                BlackholePong.this.music.play(SoundTypes.BOUNCE, true);
                if (this.ypos > (float)BlackholePong.this.height) {
                    this.yspeed *= -0.5f;
                    this.ypos = (float)BlackholePong.this.height - 0.5f;
                } else {
                    this.theta = (1.0f + (this.ypos - (float)BlackholePong.this.height) / (float)this.bound) * 1.5707964f;
                    this.yspeed += -0.6666667f * BlackholePong.tan((float)this.theta);
                    this.yspeed *= 0.98f;
                }
            }
            if (this.ypos < (float)this.bound) {
                BlackholePong.this.music.play(SoundTypes.BOUNCE, true);
                if (this.ypos < 0.0f) {
                    this.yspeed *= -0.5f;
                    this.ypos = 0.5f;
                } else {
                    this.theta = (1.0f - this.ypos / (float)this.bound) * 1.5707964f;
                    this.yspeed += 0.6666667f * BlackholePong.tan((float)this.theta);
                    this.yspeed *= 0.98f;
                }
            }
            this.bhxpos[1] = this.bh[1].get_xPos();
            this.bhypos[1] = this.bh[1].get_yPos();
            this.bhxpos[2] = this.bh[2].get_xPos();
            this.bhypos[2] = this.bh[2].get_yPos();
            this.x_diff[1] = this.xpos - (float)this.bhxpos[1];
            this.y_diff[1] = this.ypos - (float)this.bhypos[1];
            this.x_diff[2] = this.xpos - (float)this.bhxpos[2];
            this.y_diff[2] = this.ypos - (float)this.bhypos[2];
            this.radius_sq[1] = BlackholePong.sq((float)this.x_diff[1]) + BlackholePong.sq((float)this.y_diff[1]);
            this.radius_sq[2] = BlackholePong.sq((float)this.x_diff[2]) + BlackholePong.sq((float)this.y_diff[2]);
            if (this.wormhole_state < 2) {
                n = this.bh[1].get_wormhole() ? 1 : 0;
                boolean bl = this.bh[2].get_wormhole();
                if (n != 0 && bl || n == 0 && !bl) {
                    this.wormhole_state = 0;
                    this.bh_wormhole = 0;
                    this.display = true;
                } else {
                    if (n != 0 && this.bh_wormhole != 1) {
                        this.bh_wormhole = 1;
                        this.wormhole_state = 1;
                    }
                    if (bl && this.bh_wormhole != 2) {
                        this.bh_wormhole = 2;
                        this.wormhole_state = 1;
                    }
                }
            }
            n = 3 - this.bh_wormhole;
            switch (this.wormhole_state) {
                case 6: {
                    if (!this.bh[this.bh_wormhole].get_wormhole()) {
                        this.wormhole_state = 0;
                        this.bh_wormhole = 0;
                    }
                }
                case 0: {
                    if (this.radius_sq[1] < BlackholePong.sq((float)(BlackholePong.this.player1.get_horizon() * 60.0f))) {
                        this.xspeed += -53.333332f * this.x_diff[1] / this.radius_sq[1];
                        this.yspeed += -53.333332f * this.y_diff[1] / this.radius_sq[1];
                    }
                    if (this.radius_sq[2] < BlackholePong.sq((float)(BlackholePong.this.player2.get_horizon() * 60.0f))) {
                        this.xspeed += -53.333332f * this.x_diff[2] / this.radius_sq[2];
                        this.yspeed += -53.333332f * this.y_diff[2] / this.radius_sq[2];
                    }
                    if (!(BlackholePong.min((float)this.radius_sq[1], (float)this.radius_sq[2]) > BlackholePong.sq((float)90.0f))) break;
                    this.slowdown();
                    break;
                }
                case 1: {
                    if (this.radius_sq[this.bh_wormhole] < 50.0f) {
                        ++this.wormhole_state;
                        this.wormhole_timer = BlackholePong.this.millis();
                        break;
                    }
                    this.xspeed += -0.5f * this.x_diff[this.bh_wormhole];
                    this.yspeed += -0.5f * this.y_diff[this.bh_wormhole];
                    this.slowdown();
                    break;
                }
                case 2: {
                    this.xpos = this.bhxpos[this.bh_wormhole];
                    this.ypos = this.bhypos[this.bh_wormhole];
                    this.xspeed = 0.0f;
                    this.yspeed = 0.0f;
                    if (!((float)BlackholePong.this.millis() - this.wormhole_timer > 500.0f)) break;
                    ++this.wormhole_state;
                    this.wormhole_timer = BlackholePong.this.millis();
                    this.display = false;
                    break;
                }
                case 3: {
                    this.xpos = this.bhxpos[n];
                    this.ypos = this.bhypos[n];
                    this.xspeed = 0.0f;
                    this.yspeed = 0.0f;
                    if (!((float)BlackholePong.this.millis() - this.wormhole_timer > 500.0f)) break;
                    ++this.wormhole_state;
                    this.wormhole_timer = BlackholePong.this.millis();
                    this.display = true;
                    break;
                }
                case 4: {
                    this.xpos = this.bhxpos[n];
                    this.ypos = this.bhypos[n];
                    this.xspeed = 0.0f;
                    this.yspeed = 0.0f;
                    if (!((float)BlackholePong.this.millis() - this.wormhole_timer > 200.0f)) break;
                    ++this.wormhole_state;
                    this.wormhole_timer = BlackholePong.this.millis();
                    this.newxspeed = BlackholePong.this.random(-6.0f, 6.0f);
                    this.newyspeed = BlackholePong.this.random(-6.0f, 6.0f);
                    break;
                }
                case 5: {
                    this.xspeed = this.newxspeed;
                    this.yspeed = this.newyspeed;
                    if (!((float)BlackholePong.this.millis() - this.wormhole_timer > 200.0f)) break;
                    ++this.wormhole_state;
                }
            }
        }

        public int check_for_goal() {
            return this.lost;
        }

        public void reset(int n, int n2) {
            this.xpos = BlackholePong.this.width / 2;
            this.ypos = BlackholePong.this.height / 2;
            if (n == 0 && n2 == 0) {
                this.xspeed = BlackholePong.this.random(-2.0f, 2.0f);
                this.yspeed = BlackholePong.this.random(-4.0f, 4.0f);
            } else {
                this.xspeed = n;
                this.yspeed = n2;
            }
            this.lost = 0;
        }

        public void slowdown() {
            float f = BlackholePong.sq((float)this.xspeed) + BlackholePong.sq((float)this.yspeed);
            if (f > 150.0f) {
                BlackholePong.this.music.play(SoundTypes.WOOSH, true);
                float f2 = BlackholePong.sqrt((float)(150.0f / f));
                this.xspeed *= f2;
                this.yspeed *= f2;
            }
        }

        public void set_timer(float f) {
            this.wormhole_timer += f;
        }

        public void drawStar() {
            if (this.display) {
                switch (BlackholePong.this.graphics_level) {
                    case 0: {
                        BlackholePong.this.pushStyle();
                        BlackholePong.this.imageMode(3);
                        BlackholePong.this.noStroke();
                        int n = BlackholePong.this.color(255, 215, 0);
                        BlackholePong.this.fill(n);
                        BlackholePong.this.ellipse(this.xpos, this.ypos, 30.0f, 30.0f);
                        BlackholePong.this.popStyle();
                        break;
                    }
                    default: {
                        BlackholePong.this.pushStyle();
                        BlackholePong.this.imageMode(3);
                        BlackholePong.this.image(this.star, this.xpos, this.ypos);
                        BlackholePong.this.popStyle();
                    }
                }
            }
        }
    }

    class Worm {
        private final PImage worm_image;
        static final int yoffset = 20;
        static final int x1offset = 20;
        static final int x2offset = 65;
        static final int worm_offset = 50;
        float worm_time;
        int player_number;
        float worm_delay;
        boolean first;

        Worm(float f, int n) {
            this.worm_image = BlackholePong.this.loadImage("worm1.png");
            this.worm_time = BlackholePong.this.millis();
            this.worm_delay = f;
            this.player_number = n;
            this.first = true;
        }

        public void display(int n) {
            int n2 = 0;
            switch (this.player_number) {
                case 1: {
                    n2 = 20 + n * 50;
                    break;
                }
                case 2: {
                    n2 = BlackholePong.this.width - 65 - n * 50;
                }
            }
            BlackholePong.this.image(this.worm_image, n2, 20.0f);
        }

        public boolean is_ready() {
            if ((float)BlackholePong.this.millis() - this.worm_time > this.worm_delay) {
                if (this.first) {
                    BlackholePong.this.music.play(SoundTypes.NEWWORM, true);
                    this.first = false;
                }
                return true;
            }
            return false;
        }
    }
}

