/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEvent;
import net.java.games.input.ControllerListener;
import net.java.games.input.DirectInputEnvironmentPlugin;
import net.java.games.input.LinuxEnvironmentPlugin;
import net.java.games.input.OSXEnvironmentPlugin;

public abstract class ControllerEnvironment {
    protected static final byte MACOSX = 0;
    protected static final byte WINDOWS = 1;
    protected static final byte LINUX = 2;
    protected static final byte OTHER = 3;
    protected static final byte os = ControllerEnvironment.getOS();
    protected final ArrayList controllerListeners = new ArrayList();
    private static ControllerEnvironment instance;

    static void logln(String msg) {
        ControllerEnvironment.log(String.valueOf(msg) + "\n");
    }

    static void log(String msg) {
        System.out.print(msg);
    }

    protected ControllerEnvironment() {
    }

    private static byte getOS() {
        String platformName = System.getProperty("os.name");
        if (platformName.toLowerCase().indexOf("mac") != -1) {
            return 0;
        }
        if (platformName.indexOf("Windows") != -1) {
            return 1;
        }
        if (platformName.equals("Linux")) {
            return 2;
        }
        return 3;
    }

    public abstract Controller[] getControllers();

    public void addControllerListener(ControllerListener l) {
        if (l != null) {
            this.controllerListeners.add(l);
        }
    }

    public void removeControllerListener(ControllerListener l) {
        if (l != null) {
            this.controllerListeners.remove(l);
        }
    }

    protected void fireControllerAdded(Controller c) {
        ControllerEvent ev = new ControllerEvent(c);
        Iterator it = ((AbstractList)this.controllerListeners).iterator();
        while (it.hasNext()) {
            ((ControllerListener)it.next()).controllerAdded(ev);
        }
    }

    protected void fireControllerRemoved(Controller c) {
        ControllerEvent ev = new ControllerEvent(c);
        Iterator it = ((AbstractList)this.controllerListeners).iterator();
        while (it.hasNext()) {
            ((ControllerListener)it.next()).controllerRemoved(ev);
        }
    }

    public static ControllerEnvironment getEnvironment() {
        if (instance == null) {
            switch (os) {
                case 1: {
                    instance = new DirectInputEnvironmentPlugin();
                    break;
                }
                case 2: {
                    instance = new LinuxEnvironmentPlugin();
                    break;
                }
                case 0: {
                    instance = new OSXEnvironmentPlugin();
                    break;
                }
                default: {
                    throw new RuntimeException("Your operating system is not supported");
                }
            }
        }
        return instance;
    }
}

